/*
    definitions.h: Private Send Packet data.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/

#include <netinet/ip.h>
#include "../config.h"

#define COPYRIGHT "sendpacket (c) Copyright Marcelo Gornstein 1999.
This program is under the GNU/GPL license. See COPYING file for details."

#define MAJOR_VERSION "1"
#define MINOR_VERSION "5"

#define IPLEN sizeof (struct iphdr)

#if COMPILE_TCP
	#include <netinet/tcp.h>
	#define TCPLEN sizeof (struct tcphdr)
#endif
#if COMPILE_UDP
	#include <netinet/udp.h>
	#define UDPLEN sizeof (struct udphdr)
#endif
#if COMPILE_ICMP
	#include <netinet/ip_icmp.h>
	#define ICMPLEN sizeof (struct icmphdr)
#endif

struct HOST	{
                unsigned char host_ip [16];
                unsigned char host_name [50];
                struct in_addr naddr;
		};

struct PSEUDO_HEADER	{
			unsigned long saddr;
			unsigned long daddr;
			unsigned char empty;
			unsigned char protocol;
			unsigned int length;
			};
struct PACKET   {
                struct HOST src_host;
                struct HOST dst_host;
                struct iphdr *iph;
		#if COMPILE_ICMP
                    struct icmphdr *icmph;
		    unsigned char msg;
		    unsigned char code;
		    struct in_addr host;
		    struct in_addr to;
		#endif
		#if (COMPILE_TCP | COMPILE_UDP)
		    unsigned int dst_port;
		    unsigned int src_port;
    		#endif    
		#if COMPILE_TCP
            	    struct tcphdr *tcph;
		    unsigned long int seq;
		    unsigned long int ack_seq;
		    unsigned int window;
		    unsigned char syn;
		    unsigned char urg;		    
		    unsigned char fin;
		    unsigned char ack;
		    unsigned char psh;
		    unsigned char rst;
		#endif		
		#if COMPILE_UDP
	    	    struct udphdr *udph;
		#endif
	        unsigned char ttl;		
		unsigned int checksum;
		unsigned char proto [4];
		unsigned char *data;
		unsigned char file [50];
		unsigned int bufflen;
		};

