#define COMPILE_TCP 1
#define COMPILE_UDP 1
#define COMPILE_ICMP 1
#define SEND_DATA_FILE 0

#define CHECK COMPILE_TCP + COMPILE_UDP + COMPILE_ICMP

#define MAX_PACK_SIZE 2048
#define DEFAULT_SRC_HOST "127.0.0.1"
#define DEFAULT_DST_HOST "127.0.0.1"
#define DEFAULT_SRC_PORT 666
#define DEFAULT_DST_PORT 23
#define DEFAULT_PACK_TTL 255
#define DEFAULT_ICMP_MSG ICMP_ECHO
#define DEFAULT_ICMP_CODE 0
#define DEFAULT_ICMP_IPTO "10.10.10.0"
#define DEFAULT_ICMP_IP "1.1.1.1"
#define DEFAULT_DATA "/tmp/tcp-data-segment"

#ifndef DEFAULT_PROTO
    #if COMPILE_TCP
	#define DEFAULT_PROTO "tcp"
	#define DEFAULT_INIT_SEQNUM 0
	#define DEFAULT_INIT_ACKSEQNUM 1
	#define SEND_SYN_FLAG 1
	#define SEND_URG_FLAG 0
	#define SEND_RST_FLAG 0
	#define SEND_ACK_FLAG 0
	#define SEND_FIN_FLAG 0
	#define SEND_PSH_FLAG 0
	#define DEFAULT_WINDOW_SIZE 2
    #elif COMPILE_UDP
	    #define DEFAULT_PROTO "udp"
	    #elif COMPILE_ICMP
		#define DEFAULT_PROTO "icmp"
    #endif
#endif

#if CHECK == 0
#error Please choose at least one module to install. see config.h
#endif
