/*** This Programs/Libraries are (C)opyright by S. Krahmer.
 *** You may use it under the terms of the GPL. You should have
 *** already received the file COPYING that shows you your rights. If not,
 *** you can get it at http://www.cs.uni-potsdam.de/homepages/students/linuxer
 *** the logit-package. You will also find some other nice utillities there.
 ***  
 *** THERE IS ABSOLUTELY NO WARRANTY. SO YOU USE IT AT YOUR OWN RISK.
 *** IT WAS WRITTEN IN THE HOPE THAT IT WILL BE USEFULL. I'M NOT RESPONSIBLE
 *** FOR ANY DAMAGE YOU MAYBE GET DUE TO USING MY PROGRAMS.
 ***/
#ifndef _USIPP_H
#define _USIPP_H 1

#include <sys/types.h>
#include <sys/socket.h>
#include <net/ethernet.h>
#include <netinet/in.h>
#include "pcap/pcap.h"

#define ICMP_PORT 0
#ifdef USI_FREEBSD
#define PPP_LEN 24
#else
#define PPP_LEN 4
#endif
#define SLIP_LEN 24

// putting an own version of
// iphdr, udphdr, tcphdr, icmphdr and pseudohdr
// in usipp namespace to avoid collision with
// kernel ones
namespace usipp {

// the ICMP header
struct icmphdr {
   	u_int8_t type;
        u_int8_t code;
        u_int16_t sum;
        union {
           	struct {
                   	u_int16_t id;
                        u_int16_t sequence;
                } echo;
                u_int32_t gateway;
                struct {
                   	u_int16_t unused;
                        u_int16_t mtu;
                } frag;
        } un;
};

struct udphdr {
   	u_int16_t	source;
        u_int16_t	dest;
        u_int16_t	len;
        u_int16_t	check;
};


struct pseudohdr {
   	unsigned long saddr;
        unsigned long daddr;
        unsigned char zero;
        unsigned char proto;
        unsigned short len;
};

struct tcphdr
{
    	u_int16_t th_sport;		/* source port */
        u_int16_t th_dport;		/* destination port */
        u_int32_t th_seq;		/* sequence number */
        u_int32_t th_ack;		/* acknowledgement number */
#if __BYTE_ORDER == __LITTLE_ENDIAN
    	u_int8_t th_x2:4;		/* (unused) */
        u_int8_t th_off:4;		/* data offset */
#elif __BYTE_ORDER == __BIG_ENDIAN
    	u_int8_t th_off:4;		/* data offset */
        u_int8_t th_x2:4;		/* (unused) */
#endif
    	u_int8_t th_flags;
#ifndef TH_FIN
#define	TH_FIN	0x01
#endif
#ifndef TH_SYN
#define	TH_SYN	0x02
#endif
#ifndef TH_RST
#define	TH_RST	0x04
#endif
#ifndef TH_PUSH
#define	TH_PUSH	0x08
#endif
#ifndef TH_ACK
#define	TH_ACK	0x10
#endif
#ifndef TH_URG
#define	TH_URG	0x20
#endif
    	u_int16_t th_win;		/* window */
        u_int16_t th_sum;		/* checksum */
        u_int16_t th_urp;		/* urgent pointer */
};


struct iphdr
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
    	unsigned int ihl:4;
        unsigned int version:4;
#elif __BYTE_ORDER == __BIG_ENDIAN
    	unsigned int version:4;
        unsigned int ihl:4;
#else
# error	"Please fix <bits/endian.h>"
#endif
    	u_int8_t tos;
        u_int16_t tot_len;
        u_int16_t id;
        u_int16_t frag_off;
        u_int8_t ttl;
        u_int8_t protocol;
        u_int16_t check;
        u_int32_t saddr;
        u_int32_t daddr;
    /*The options start here. */
};

// end of namespace usipp
};	

class IP {
private:
      	struct usipp::iphdr iph;
	char options[40];
        struct sockaddr_in saddr;
	struct ether_header ether;
        int rawfd;

// all the protected members are for packet-capturing only
protected:
   	bpf_u_int32 localnet, netmask;
        pcap_t *pd;
        char errbuff[PCAP_ERRBUF_SIZE], filter_string[1000];
        struct bpf_program filter;
        struct pcap_pkthdr phdr;
        int datalink;
	bool initialized;
public:
      	IP(const char*, u_int8_t);	// IP("foo.foo");
        IP(u_int32_t, u_int8_t);	
        virtual ~IP();

      	u_int8_t get_hlen();
        u_int8_t get_vers();
        u_int8_t get_tos();
        u_int16_t get_totlen();
        u_int16_t get_id();
        u_int16_t get_fragoff();
        u_int8_t get_ttl();
        u_int8_t get_proto();
        u_int16_t get_sum();
        u_int32_t get_src();
        u_int32_t get_dst();
        char *get_src(int);
	char *get_dst(int);
        
        int set_hlen(u_int8_t);
        int set_vers(u_int8_t);
        int set_tos(u_int8_t);
        int set_totlen(u_int16_t);
        int set_id(u_int16_t);
        int set_fragoff(u_int16_t);
        int set_ttl(u_int8_t);
        int set_proto(u_int8_t);
        int set_sum(u_int16_t);	 // should NOT be used; just to be complete...
        int set_src(u_int32_t);
        int set_dst(u_int32_t);
        int set_src(const char*);
        int set_dst(const char*);

	virtual int sendpack(void*, int);
	virtual int sendpack(char*);
	virtual int recvpack(void*, int);
        virtual int sniffpack(void*, int);

	virtual int init_device(char*, int, int);
        int setfilter(char*);
        
        friend unsigned short in_cksum(unsigned short*, int);
};



class ICMP : public IP {
private:
   	struct usipp::icmphdr icmphdr;
public:
      	ICMP(const char*);

        virtual int sendpack(void*, int);
        virtual int sendpack(char*);
        virtual int recvpack(void*, int);
        virtual int sniffpack(void*, int);
        
        virtual int init_device(char*, int, int);
        
        int set_type(u_int8_t);
        int set_code(u_int8_t);
        int set_id(u_int16_t);
        int set_seq(u_int16_t);
        int set_gateway(u_int32_t);
        int set_mtu(u_int16_t);
        
        u_int8_t get_type();
        u_int8_t get_code();
        u_int16_t get_id();
        u_int16_t get_seq();
        u_int32_t get_gateway();
        u_int16_t get_mtu();
};

class UDP : public IP {
private:
      struct usipp::udphdr udph;
      struct usipp::pseudohdr pseudo;
public:
      UDP(const char*);
      
      u_int16_t get_srcport();
      u_int16_t get_dstport();
      u_int16_t get_len();
      u_int16_t get_sum();
      
      int set_srcport(u_int16_t);
      int set_dstport(u_int16_t);
      int set_len(u_int16_t);
      int set_sum(u_int16_t);
          
      virtual int sendpack(void*, int);
      virtual int sendpack(char*);
      virtual int recvpack(void*, int);
      virtual int sniffpack(void*, int);
      
      virtual int init_device(char*, int, int);
};    



class TCP : public IP {
private:
      struct usipp::tcphdr tcph;
      char options[40];
      struct usipp::pseudohdr pseudo;
public:
      TCP(const char*);
      
      u_int16_t get_srcport();
      u_int16_t get_dstport();
      u_int32_t  get_seq();
      u_int32_t  get_ack();
      u_int8_t get_off();
      u_int8_t get_flags();      
      u_int16_t get_win();
      u_int16_t get_sum();
      u_int16_t get_urg();
      
      int set_srcport(u_int16_t);
      int set_dstport(u_int16_t);
      int set_seq(u_int32_t);
      int set_ack(u_int32_t);
      int set_off(u_int8_t);
      int set_flags(u_int8_t);
      int set_win(u_int16_t);
      int set_sum(u_int16_t);
      int set_urg(u_int16_t);
      
      virtual int recvpack(void*, int);
      virtual int sniffpack(void*, int);
      virtual int sendpack(void*, int);
      virtual int sendpack(char*);
      
      virtual int init_device(char*, int, int);
      
};

#endif	// _USIPP_H

