/*** This Programs/Libraries are (C)opyright by S. Krahmer.
 *** You may use it under the terms of the GPL. You should have
 *** already received the file COPYING that shows you your rights. If not,
 *** you can get it at http://www.cs.uni-potsdam.de/homepages/students/linuxer
 *** the logit-package. You will also find some other nice utillities there.
 ***  
 *** THERE IS ABSOLUTELY NO WARRANTY. SO YOU USE IT AT YOUR OWN RISK.
 *** IT WAS WRITTEN IN THE HOPE THAT IT WILL BE USEFULL. I'M NOT RESPONSIBLE
 *** FOR ANY DAMAGE YOU MAYBE GET DUE TO USING MY PROGRAMS.
 ***/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "usi++/usi++.h"

UDP::UDP(const char *host)
#ifndef IPPROTO_UDP
#define IPPROTO_UDP 17
#endif
      : IP(host, IPPROTO_UDP)
{
   	memset(&udph, 0, sizeof(udph));        
        memset(&pseudo, 0, sizeof(pseudo));
}

u_int16_t UDP::get_srcport()
{
   	return ntohs(udph.source);
}

u_int16_t UDP::get_dstport()
{
   	return ntohs(udph.dest);
}

u_int16_t UDP::get_len()
{
   	return ntohs(udph.len);
}

u_int16_t UDP::get_sum()
{
   	return udph.check;
}

int UDP::set_srcport(u_int16_t sp)
{
   	udph.source = htons(sp);
        return 0;
}

int UDP::set_dstport(u_int16_t dp)
{
   	udph.dest = htons(dp);
        return 0;
}

int UDP::set_len(u_int16_t l)
{
   	udph.len = htons(l);
        return 0;
}

int UDP::set_sum(u_int16_t s)
{
   	udph.check = s;
        return 0;
}

int UDP::sendpack(void *buf, int paylen)
{
	int len = paylen + sizeof(udph) + sizeof(pseudo);
	char *tmp = new char[len];
	memset(tmp, 0, len);

   	// build a pseudoheader for IP-checksum, as
        // required per RFC ???	
	pseudo.saddr = get_src();	// sourceadress
	pseudo.daddr = get_dst();	// destinationadress
	pseudo.zero = 0;
	pseudo.proto = IPPROTO_UDP;
	pseudo.len = htons(sizeof(udph) + paylen);
	
	udph.len = htons(paylen + sizeof(udph));
	udph.check = 0;
	
        // copy pseudohdr+header+data to buffer
	memcpy(tmp, &pseudo, sizeof(pseudo));
	memcpy(tmp + sizeof(pseudo), &udph, sizeof(udph));
	memcpy(tmp + sizeof(pseudo) + sizeof(udph), buf, paylen);
	
        // calc checksum over it
	struct usipp::udphdr *u = (struct usipp::udphdr*)(tmp + sizeof(pseudo));
	u->check = in_cksum((unsigned short*)tmp, len);
	
	IP::sendpack(tmp + sizeof(pseudo), len - sizeof(pseudo));
	
	delete [] tmp;
	return 0;
}


int UDP::sendpack(char *s)
{
	return sendpack(s, strlen(s));
}


int UDP::recvpack(void *buf, int len)
{  	
        char *tmp = new char[len+sizeof(udph)];
        memset(tmp, 0, len + sizeof(udph));
        
        IP::recvpack(tmp, len + sizeof(udph));
        memcpy(&udph, tmp, sizeof(udph));
        
	if (buf)
		memcpy(buf, tmp + sizeof(udph), len);
        
        delete [] tmp;
        return 0;
}
        

int UDP::sniffpack(void *buf, int len)
{  	
        char *tmp = new char[len+sizeof(udph)];
	int r = 0;
        memset(tmp, 0, len + sizeof(udph));
        
        r = IP::sniffpack(tmp, len + sizeof(udph));
        memcpy(&udph, tmp, sizeof(udph));

	if (buf)
    		memcpy(buf, tmp + sizeof(udph), len);
        
        delete [] tmp;
        return r-sizeof(udph);
}

// initialize device for packet-capturing
int UDP::init_device(char *dev, int promisc, int snaplen)
{
   	
        if ((pd = pcap_open_live(dev, snaplen, promisc, 500, errbuff)) == NULL) {
           	fprintf(stderr, "%s", errbuff);
                exit(errno);
        }
        
        if (pcap_lookupnet(dev, &localnet, &netmask, errbuff) < 0) {
           	pcap_perror(pd, "pcap_lookupnet");
                exit(errno);
        }
        sprintf(filter_string, "udp");
        
        if (pcap_compile(pd, &filter, filter_string, 1, netmask) < 0) {
           	pcap_perror(pd, "pcap_compile");
                exit(errno);
        }
        if (pcap_setfilter(pd, &filter) < 0) {
           	pcap_perror(pd, "pcap_setfilter");
                exit(errno);
        }
        if ((datalink = pcap_datalink(pd)) < 0) {
           	pcap_perror(pd, "pcap_datalink");
                exit(errno);
        }
	
	initialized = true;
        return 0;
}

