/*** This Programs/Libraries are (C)opyright by S. Krahmer.
 *** You may use it under the terms of the GPL. You should have
 *** already received the file COPYING that shows you your rights. If not,
 *** you can get it at http://www.cs.uni-potsdam.de/homepages/students/linuxer
 *** the logit-package. You will also find some other nice utillities there.
 ***  
 *** THERE IS ABSOLUTELY NO WARRANTY. SO YOU USE IT AT YOUR OWN RISK.
 *** IT WAS WRITTEN IN THE HOPE THAT IT WILL BE USEFULL. I'M NOT RESPONSIBLE
 *** FOR ANY DAMAGE YOU MAYBE GET DUE TO USING MY PROGRAMS.
 ***/
#include <string.h>
#include <stdlib.h>
#include "config.h"
#include <errno.h>
#include "usi++/usi++.h"


TCP::TCP(const char *host)
#ifndef IPPROTO_TCP
#define IPPROTO_TCP 6
#endif
     : IP(host, IPPROTO_TCP)
{
	srand(time(NULL));
   	memset(&tcph, 0, sizeof(tcph));
        memset(&pseudo, 0, sizeof(pseudo));
	memset(options, 0, sizeof(options));
	
        tcph.th_off = 5;
        tcph.th_ack = htonl(rand());
        tcph.th_seq = htonl(rand());
}

u_int16_t TCP::get_srcport()
{
   	return ntohs(tcph.th_sport);
}

u_int16_t TCP:: get_dstport()
{
   	return ntohs(tcph.th_dport);
}

u_int32_t TCP::get_seq()
{
   	return ntohl(tcph.th_seq);
}

u_int32_t TCP::get_ack()
{
   	return ntohl(tcph.th_ack);
}

u_int8_t TCP::get_off()
{
   	return tcph.th_off;
}

u_int8_t TCP::get_flags()
{
   	return tcph.th_flags;
}

u_int16_t TCP::get_win()
{
   	return ntohs(tcph.th_win);
}

u_int16_t TCP::get_sum()
{
   	return tcph.th_sum;
}

u_int16_t TCP::get_urg()
{
   	return tcph.th_urp;
}

int TCP::set_srcport(u_int16_t sp)
{
   	tcph.th_sport = htons(sp);
        return 0;
}

int TCP::set_dstport(u_int16_t dp)
{
   	tcph.th_dport = htons(dp);
        return 0;
}

int TCP::set_seq(u_int32_t s)
{
   	tcph.th_seq = htonl(s);
        return 0;
}

int TCP::set_ack(u_int32_t a)
{
   	tcph.th_ack = htonl(a);
        return 0;
}

int TCP::set_off(u_int8_t o)
{
   	tcph.th_off = o;
        return 0;
}

int TCP::set_flags(u_int8_t f)
{
   	tcph.th_flags = f;
        return 0;
}

int TCP::set_win(u_int16_t w)
{
   	tcph.th_win = htons(w);
        return 0;
}

int TCP::set_sum(u_int16_t s)
{
   	tcph.th_sum = s;
        return 0;
}

int TCP::set_urg(u_int16_t u)
{
   	tcph.th_urp = u;
        return 0;
}


int TCP::sendpack(void *buf, int paylen)
{
	int len = paylen + sizeof(tcph) + sizeof(pseudo);
	char *tmp = new char[len];
	memset(tmp, 0, len);

   	// build a pseudoheader for IP-checksum, as
        // required per RFC ???	
	pseudo.saddr = get_src();	// sourceadress
	pseudo.daddr = get_dst();	// destinationadress
	pseudo.zero = 0;
	pseudo.proto = IPPROTO_TCP;
	pseudo.len = htons(sizeof(tcph) + paylen);
	
	tcph.th_sum = 0;
	
        // copy pseudohdr+header+data to buffer
	memcpy(tmp, &pseudo, sizeof(pseudo));
	memcpy(tmp + sizeof(pseudo), &tcph, sizeof(tcph));
	memcpy(tmp + sizeof(pseudo) + sizeof(tcph), buf, paylen);
	
        // calc checksum over it
	struct usipp::tcphdr *t = (struct usipp::tcphdr*)(tmp + sizeof(pseudo));
	t->th_sum = in_cksum((unsigned short*)tmp, len);
	
	IP::sendpack(tmp + sizeof(pseudo), len - sizeof(pseudo));
	
	delete [] tmp;
	return 0;
}


int TCP::sendpack(char *s)
{
	return sendpack(s, strlen(s));
}


int TCP::recvpack(void *buf, int len)
{  	
	int xlen = len + sizeof(tcph) + sizeof(options);
	
        char *tmp = new char[xlen];
        memset(tmp, 0, xlen);
        
        IP::recvpack(tmp, xlen);
	int tcplen = tcph.th_off<<2;
	
	if (tcplen > 60)
		tcplen = 60;
	
        memcpy(&tcph, tmp, tcplen);
        
	if (buf)
		memcpy(buf, tmp + tcplen, len);
        
        delete [] tmp;
        return 0;
}
        

int TCP::sniffpack(void *buf, int len)
{  	
        int xlen = len + sizeof(tcph) + sizeof(options);
	
	char *tmp = new char[xlen];
	int r = 0;
	
        memset(tmp, 0, xlen);
        
        r = IP::sniffpack(tmp, len + sizeof(tcph));
	int tcplen = tcph.th_off<<2;
	
	if (tcplen > 60)
		tcplen = 60;
	
        memcpy(&tcph, tmp, tcplen);
        
	if (buf)
		memcpy(buf, tmp + tcplen, len);
        
        delete [] tmp;
        return r - tcplen;
}
        

// initialize device for packet-capturing
int TCP::init_device(char *dev, int promisc, int snaplen)
{
   	
        if ((pd = pcap_open_live(dev, snaplen, promisc, 500, errbuff)) == NULL) {
           	fprintf(stderr, "%s", errbuff);
                exit(errno);
        }
        
        if (pcap_lookupnet(dev, &localnet, &netmask, errbuff) < 0) {
           	pcap_perror(pd, "pcap_lookupnet");
                exit(errno);
        }
        sprintf(filter_string, "tcp");
        
        if (pcap_compile(pd, &filter, filter_string, 1, netmask) < 0) {
           	pcap_perror(pd, "pcap_compile");
                exit(errno);
        }
        if (pcap_setfilter(pd, &filter) < 0) {
           	pcap_perror(pd, "pcap_setfilter");
                exit(errno);
        }
        if ((datalink = pcap_datalink(pd)) < 0) {
           	pcap_perror(pd, "pcap_datalink");
                exit(errno);
        }
	
	initialized = true;
        return 0;
}

