/*** This Programs/Libraries are (C)opyright by S. Krahmer.
 *** You may use it under the terms of the GPL. You should have
 *** already received the file COPYING that shows you your rights. If not,
 *** you can get it at http://www.cs.uni-potsdam.de/homepages/students/linuxer
 *** the logit-package. You will also find some other nice utillities there.
 ***  
 *** THERE IS ABSOLUTELY NO WARRANTY. SO YOU USE IT AT YOUR OWN RISK.
 *** IT WAS WRITTEN IN THE HOPE THAT IT WILL BE USEFULL. I'M NOT RESPONSIBLE
 *** FOR ANY DAMAGE YOU MAYBE GET DUE TO USING MY PROGRAMS.
 ***/
#include <stdio.h>
#include "config.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <iostream.h>
#include "usi++/usi++.h"

ICMP::ICMP(const char* host) 
#ifndef IPPROTO_ICMP
#define IPPROTO_ICMP 1
#endif
      : IP(host, IPPROTO_ICMP)
{        
        // clear memory
        memset(&icmphdr, 0, sizeof(icmphdr));
                
}
 
int ICMP::set_type(u_int8_t t)
{       
        icmphdr.type = t;
        return 0;
}

u_int8_t ICMP::get_type()
{
   	return icmphdr.type;
}

int ICMP::set_code(u_int8_t c)
{
   	icmphdr.code = c;
        return 0;
}

u_int8_t ICMP::get_code()
{
   	return icmphdr.code;
}

int ICMP::set_gateway(u_int32_t g)
{
   	icmphdr.un.gateway = g;
        return 0;
}

u_int32_t ICMP::get_gateway()
{
   	return icmphdr.un.gateway;
}

int ICMP::set_mtu(u_int16_t mtu)
{
   	icmphdr.un.frag.mtu = mtu;
   	return 0;
}

u_int16_t ICMP::get_mtu()
{
   	return icmphdr.un.frag.mtu;
}


int ICMP::set_id(u_int16_t id)
{
   	icmphdr.un.echo.id = id;
        return 0;
}

u_int16_t ICMP::get_id()
{
   	return icmphdr.un.echo.id;
}

int ICMP::set_seq(u_int16_t s)
{
   	icmphdr.un.echo.sequence = s;
        return 0;
}

u_int16_t ICMP::get_seq()
{
   	return icmphdr.un.echo.sequence;
}

int ICMP::sendpack(void *payload, int paylen)
{
   	int len = sizeof(struct usipp::icmphdr) + paylen;	// the packetlenght
                
        struct usipp::icmphdr *i;

        // s will be our packet
   	char *s = new char[len];
        memset(s, 0, len);
        
        // copy ICMP header to packet
        memcpy((char*)s, (struct usipp::icmphdr*)&this->icmphdr, sizeof(icmphdr));

   	if (payload)
           	memcpy(s+sizeof(icmphdr), payload, paylen);

        i = (struct usipp::icmphdr*)s;
        
        // calc checksum over packet
        i->sum = 0;
	i->sum = in_cksum((unsigned short*)s, len);
        
        return IP::sendpack(s, len);
        
}

int ICMP::sendpack(char *payload)
{
   	return sendpack(payload, strlen(payload));
}
        
int ICMP::recvpack(void *s, int len)
{
   	char *tmp = new char[len];
        
   	IP::recvpack(tmp, len);
	
        // point to ICMP header
        struct usipp::icmphdr *icmph = (struct usipp::icmphdr*)(tmp);
        
        // save ICMP header for public functions
        memcpy(&icmphdr, icmph, sizeof(struct usipp::icmphdr));
        
        // and give user the payload
        if (s)
		memcpy(s, ++icmph, len);
        
        delete[] tmp;
        return 0;
}    

// handle packets, that are NOT actually for the
// local adress!
int ICMP::sniffpack(void *s, int len)
{
   	char *tmp = new char[len];
        int r = 0;
	
   	r = IP::sniffpack(tmp, len);
	
        // point to ICMP header
        struct usipp::icmphdr *icmph = (struct usipp::icmphdr*)(tmp);
        
        // save ICMP header for public functions
        memcpy(&icmphdr, icmph, sizeof(struct usipp::icmphdr));
        
        // and give user the payload
	if (s)
    		memcpy(s, ++icmph, len);
        
        delete[] tmp;
        return r-sizeof(struct usipp::icmphdr);
}    

// initialize device for packet-capturing
int ICMP::init_device(char *dev, int promisc, int snaplen)
{
   	
        if ((pd = pcap_open_live(dev, snaplen, promisc, 500, errbuff)) == NULL) {
           	fprintf(stderr, "%s", errbuff);
                exit(errno);
        }
        
        if (pcap_lookupnet(dev, &localnet, &netmask, errbuff) < 0) {
           	pcap_perror(pd, "pcap_lookupnet");
                exit(errno);
        }
        sprintf(filter_string, "icmp");
        
        if (pcap_compile(pd, &filter, filter_string, 1, netmask) < 0) {
           	pcap_perror(pd, "pcap_compile");
                exit(errno);
        }
        if (pcap_setfilter(pd, &filter) < 0) {
           	pcap_perror(pd, "pcap_setfilter");
                exit(errno);
        }
        if ((datalink = pcap_datalink(pd)) < 0) {
           	pcap_perror(pd, "pcap_datalink");
                exit(errno);
        }
	
	initialized = true;
        return 0;
}

