/* snifflib
 *
 * by scut
 *
 */

#ifndef	Z_SNIFF_H
#define	Z_SNIFF_H

#include <pcap.h>
#include "packet.h"

#define	SNAPLEN		65535
#define	PROMISC		1
#define	READ_TIMEOUT	0


typedef struct	s_dev {
	int			error;		/* error flag */

	pcap_t			*pd;		/* packet capture descriptor */
	char			*interface;	/* interface name */
	int			linktype;	/* link layer type */
	unsigned long int	linkhdrlen;	/* length of the link layer frame header */
	bpf_u_int32		localnet;	/* local network address */
	bpf_u_int32		netmask;	/* netmask of local network */

} s_dev;


typedef struct	sniff_info {
	s_dev		*device;		/* device structure of the sniffing device */
	pq_thread	*pq_thd;		/* packet queue list root pointer */
} sniff_info;


int		sniff_new (pthread_t *tid, char *interface, pq_thread *pq_thd);
void		*sniff_handle (sniff_info *sinfo);
s_dev		*sniff_open (char *devname);
pcap_t		*sniff_pcap_open (char *device);
void		sniff_dev_free (s_dev *device);
int		sniff_dev_ip (const char *dev, struct in_addr *ip);

#endif

