/*
    pseudo.c: fills the pseudo header to make the checksum.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>
#include "definitions.h"

void fill_pseudo (struct PSEUDO_HEADER *p, struct PACKET h)
{
p->saddr = h.src_host.naddr.s_addr;
p->daddr = h.dst_host.naddr.s_addr;

#if COMPILE_TCP
if (!strncmp (h.proto, "tcp", 3)) p->protocol = 6;
p->length = htons (TCPLEN);
#endif

#if COMPILE_UDP
if (!strncmp (h.proto, "udp", 3)) p->protocol = 17;
p->length = htons (UDPLEN);
#endif

#if COMPILE_ICMP
if (!strncmp (h.proto, "icmp", 4)) p->protocol = 1;
p->length = htons (ICMPLEN);
#endif
}

