#include "ippacket.h"
struct pseudohdr
  {
      unsigned long saddr;
      unsigned long daddr;
      char useless;
      unsigned char protocol;
      unsigned short leng;
  };

int sendpckt(unsigned char *packet, struct iphdr *ip_header, int num)
{
    int i = 1, s;
    struct sockaddr_in sockinfo;

    if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)
      {
	  perror("socket");
	  return -1;
      }
    if (setsockopt(s, IPPROTO_IP, IP_HDRINCL, &i, sizeof(int)) == -1)
      {
	  perror("setsockopt");
	  return -1;
      }
    sockinfo.sin_family = AF_INET;
    sockinfo.sin_addr.s_addr = ip_header->daddr;
    if (num == -1)
	for (;;)
	    if (sendto(s, packet, ip_header->tot_len, 0, (struct sockaddr *) &sockinfo,
		       sizeof(struct sockaddr)) == -1)
	      {
		  perror("sendto");
		  return -1;
	      }
    for (i = 0; i < num; i++)
	if (sendto(s, packet, ip_header->tot_len, 0, (struct sockaddr *)
		   &sockinfo, sizeof(struct sockaddr)) == -1)
	  {
	      perror("sendto");
	      return -1;
	  }
    return 0;
}

void add_udphdr(char *pkt, struct str_args args)
{
    struct udphdr *udp_header;

    udp_header = (struct udphdr *) (pkt + IP_SIZE);
    udp_header->source = htons(args.udp.s_port);
    udp_header->dest = htons(args.udp.d_port);
    udp_header->len = IP_SIZE + UDP_SIZE + DATA_SIZE;

}


void add_icmphdr(char *pkt, struct str_args args)
{
    struct icmphdr *icmp_header;

    icmp_header = (struct icmphdr *) (pkt + IP_SIZE);
    icmp_header->type = args.icmptype;
    icmp_header->un.echo.sequence = 3;
    icmp_header->un.echo.id = getpid();
    icmp_header->checksum = in_cksum((unsigned short *) icmp_header,
				     sizeof(struct icmphdr));
}

void add_tcphdr(char *pkt, struct str_args args, struct iphdr *ip_header)
{
    struct tcphdr *tcp_header;
    struct pseudohdr *pseudo;

    pseudo =
	(struct pseudohdr *) (pkt + sizeof(struct iphdr) - sizeof(struct pseudohdr));

    pseudo->saddr = ip_header->saddr;
    pseudo->daddr = ip_header->daddr;
    pseudo->useless = 0;
    pseudo->protocol = 6;
    pseudo->leng = htons(sizeof(struct tcphdr) + DATA_SIZE);

    tcp_header = (struct tcphdr *) (pkt + IP_SIZE);
    tcp_header->th_sport = htons(args.tcp.s_port);
    tcp_header->th_dport = htons(args.tcp.d_port);
    tcp_header->th_seq = htonl(args.tcp.seq);
    tcp_header->th_ack = htonl(args.tcp.ack);
    tcp_header->th_off = 5;
    tcp_header->th_win = htons(args.tcp.win);
    tcp_header->th_flags = args.tcp.flags;
    tcp_header->th_urp = htons(args.tcp.urgpoint);

    tcp_header->th_sum =
	in_cksum((unsigned short *) pseudo,
		 TCP_SIZE + DATA_SIZE + sizeof(struct pseudohdr));

    printf("%d\n", tcp_header->th_sum);
}
