/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#include "casl.h"

static FILE *get_next(FILE *input);

extern int AlwaysWarn;
extern asr_t *Top;
extern int ErrorFound;
extern FILE *caslin;
extern int Looping;
extern char *casl_file;
extern int casl_line;

static void sxs_enter(void);
static void sxs_exit(void);
void proc_enter(void);
void proc_exit(void);
void scope_enter(void);
void scope_exit(void);
int casl_parse(void);

/* Catch errors */

jmp_buf SxSbuf;

/* ----------------------------------------------------------------------------
** Step by step mode.  Prompts for a list of statements, then executes them.
*/

asr_t *casl_sxs(asr_t *args) {
	FILE *fp = NULL;
	char buf[100];
	int c = 0;

	sxs_enter();

	printf("Enter CASL statements. Type \"sxsend\" when finished.\n"
	       "'.' on a line by itself ends a statement and parses.\n");

	while(1) {
		sprintf(buf, "sxsBuf (%d)", c++);
		casl_file = buf;
		casl_line = 0;	

		printf(": %s\n"
		       "---------------------------------\n", buf);

		
		if(!(fp = get_next(stdin)))
			break;

		caslin = fp;
		casl_line = 1;
		while(casl_parse())
			/**/;

		if(ErrorFound || !Top) {
			error(E_WARN, "Syntax error parsing input");
			ErrorFound = 0;
			continue;
		} 

		if(setjmp(SxSbuf)) {
			fclose(fp);
			continue;
		}

		printf("\n");

		eval_statement(Top);

		/* XXX free(Top); */

		fclose(fp);
	}

	sxs_exit();

	return(NULL);
}

/* ----------------------------------------------------------------------------
** Enter a proc.
*/

int sL;

void proc_enter(void) {
	scope_enter();
	sL = Looping;
	Looping = 0;
}

/* ----------------------------------------------------------------------------
** Leave a proc.
*/

void proc_exit(void) {
	scope_exit();
	Looping = sL;
}

/* ----------------------------------------------------------------------------
** Start running the sxs code.
*/

int sE;
char *sF;
int sLn;
FILE *sFp;
asr_t *sT;

static void sxs_enter(void) {
	sE = ErrorFound;
	sF = casl_file;
	sLn = casl_line;
	sFp = caslin;
	sT = Top;
	AlwaysWarn = 1;
	proc_enter();
}

/* ----------------------------------------------------------------------------
** Clean up after the sxs code.
*/

static void sxs_exit(void) {
	ErrorFound = sE;
	casl_file = sF;
	casl_line = sLn;
	caslin = sFp;
	Top = sT;
	AlwaysWarn = 0;
	proc_exit();
}

/* ----------------------------------------------------------------------------
** Read the next line in a file.
*/

static FILE *get_next(FILE *input) {
	FILE *fp = NULL;
	char buffer[1024];

	int c = 1;

	while(1) {

		printf("%d ", c++);

		if(!(fgets(buffer, 1024, input))) 
			break;

		if(!fp)
			fp = tmpfile();

		if(buffer[0] == '.') {
			break;
		}

		if(strstr(buffer, "sxsend")) {
			fclose(fp);
			return(NULL);
		}

		fputs(buffer, fp);
	}

	if(fp)
		fseek(fp, 0, SEEK_SET);

	return(fp);
}
