#!/bin/sh -x

while [ $# -gt 0 ]; do
        CURARG=$1
        shift
        case $CURARG in
        -t)
                if [ ! \( $# -gt 0 \) ]; then
                        echo "Argument -t requires date string (MMDDhhmm[[CC]YY
][.ss]"
                        exit 1
                fi
                TOUCHDATE="$1"
                if touch -t "$TOUCHDATE" /tmp/foo$$; then
                        rm -f /tmp/foo$$
                else
                        echo "Invalid date format for -t"
                        exit 1
                fi
                shift
                ;;
        -d)
                if [ ! \( $# -gt 0 \) ]; then
                        echo "Argument -d requires directory"
                        exit 1
                fi
                DIRNAME="$1"
                ;;
	-n)
		SKIPTAR="exit 0"
		;;
        -*)
                echo "Invalid argument $CURARG"
                exit 1
                ;;
        *)
                if [ -n "$DIRNAME" ]; then
                        echo "Multiple directories given on command line"
                        exit 1
                fi
                DIRNAME="$CURARG"
        esac
done


# ---------------------------
OS=`uname | sed 's#/#_#g'`
if [ $OS = "SunOS" ]; then
   ECHO="/usr/ucb/echo"
else
   ECHO="echo"
fi

FIND=find

BINS="casl cpp"
BFILES="build/casl build/cpp"

FILES="\
    text/CREDITS.TXT "

EXAMPLES=`$FIND examples ! '(' -name CVS -prune ')' -type f`


# ---------------------------
# get directory
if [ -n "$DIRNAME" ] ; then
        DIST=$DIRNAME
else
    $ECHO -n "Enter directory: "
    read DIST
    test "x" = "x$DIST" && exit 1
fi

if [ -d $DIST ] ; then
    $ECHO -n "$DIST already exists  Overwrite? [n] "
    read answer
    test "x$answer" = "xy" || exit 1
fi


# ---------------------------
set -e
$ECHO "Make directory"
test -d $DIST || mkdir $DIST

$ECHO "Copy main files"

for F in $BFILES
do
	echo `basename $F`
	cp $F $DIST
done

for F in $FILES 
do
	echo `basename $F`
	cat $F > $DIST/`basename $F`
done

cat text/LICENSE.TXT > $DIST/LICENSE.TXT
cat text/WHATSNEW.TXT > $DIST/WHATSNEW.TXT
cat text/CASL.PDF > $DIST/CASL.PDF

test -d $DIST/examples || mkdir $DIST/examples
test -d $DIST/include || mkdir $DIST/include

#cp $EXAMPLES $DIST/examples
cp casl-basedir/examples/*.casl $DIST/examples
cp casl-basedir/include/*.casl $DIST/include
cat casl-basedir/casl.conf > $DIST/casl.conf

cp text/install.sh $DIST
chmod a+x text/install.sh


echo "Copy GNU CPP"
tar -cf $DIST/cpp-src.tar `$FIND gnu-cpp ! '(' -name CVS -prune ')' -type f`
gzip $DIST/cpp-src.tar

$ECHO "strip binaries"
for bin in $BINS ; do
    strip $DIST/$bin
done

if [ -n "$TOUCHDATE" ]; then
	find $DIST -depth -exec touch -t $TOUCHDATE {} \; > /dev/null
fi

$SKIPTAR

$ECHO -n "Make a tarball? [n] "
read answer
test "x$answer" = "xy" || exit 1

(
    cd `dirname $DIST`
    tar -cf /tmp/dist.$$.tar `basename $DIST` && gzip /tmp/dist.$$.tar
    mv /tmp/dist.$$.tar.gz $DIST/casl.tar.gz
    $ECHO "distribution is in $DIST/casl.tar.gz"
)
