/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef SYMBOL_INCLUDED
#define SYMBOL_INCLUDED

#include "casl-asr.h"
#include "casl-eval.h"

int st_insert(char *id, asr_t *node, int level);
int st_replace(char *id, asr_t *node, int Level);
asr_t *st_get(char *id, int level);
asr_t *st_get_uplevel(char *id);
void st_remove(char *id, int level);
void st_push(void);
void st_pop(void);
void st_collect(void);
void st_globalfree(void);
int st_global(char *id);

/* builtin functions */

void bt_insert(char *id, asr_t *(*func)(asr_t *));
void add_builtins(void);

/* XXX this doesn't belong here anymore */

asr_t *builtin_callargs(asr_t *l);
void builtin_freeargs(asr_t *);

/* struct symbols */

void sd_new(char *);
int  sd_addfield(char *, sdef *);
sdef *sd_getfield(char *, char *);
st  *sd_get(char *);
int  sd_len(char *);

extern int Level;

#define BUILTIN		-1
#define UPLEVEL		-2


#endif
