/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>

#define DEFAULT_BUILTINTABFILE 		 "builtintab"
#define DEFAULT_SOURCEFILE 		 "builtins.c"
#define DEFAULT_OUTFILE			 "builtins-gen.c"

#define MARKERSTRING			 "INSERT TABLE HERE"
#define BANNERCOMMENT						\
"\n\t/* AUTOMATICALLY GENERATED. DO NOT EDIT. */\n\n"		

void output(char *input, FILE *fp);
char *strsc(char *string);

int Line;

int main(int argc, char **argv) {
	FILE *fp, *ft, *fo;
	char buffer[1024];

	char *builtintabfile;
	char *sourcefile;
	char *outfile;
	int i;

	if(!argv[1] || argv[2][0] == '-')
		builtintabfile = DEFAULT_BUILTINTABFILE;
	else
		builtintabfile = argv[1];

	if(!argv[1] || !argv[2] || argv[2][0] == '-')
		sourcefile = DEFAULT_SOURCEFILE;
	else
		sourcefile = argv[2];

	if(!argv[1] || !argv[2] || !argv[3] || argv[3][0] == '-')
		outfile = DEFAULT_OUTFILE;
	else
		outfile = argv[3];

	if(!(fp = fopen(builtintabfile, "r"))) {
		fprintf(stderr, "unable to open \"%s\": %s\n",
			builtintabfile, strerror(errno));
		exit(1);
	}

	if(!(fo = fopen(sourcefile, "r"))) {
		fprintf(stderr, "unable to open \"%s\": %s\n",
			sourcefile, strerror(errno));
		exit(1);
	}

	if(!(ft = fopen(outfile, "w"))) {
		fprintf(stderr, "unable to open \"%s\": %s\n",
			outfile, strerror(errno));
		exit(1);
	}

	while(fgets(buffer, 1024, fo)) {
		if(strstr(buffer, MARKERSTRING))
			break;
		else
			fputs(buffer, ft);
	}

	fputs(BANNERCOMMENT, ft);

	while(fgets(buffer, 1024, fp)) {
		Line++;

		if(buffer[0] == '\n')
			continue;

		strsc(buffer);
	
		if(buffer[0] == '#')
			continue;

		output(buffer, ft);
	}	
		
	while(fgets(buffer, 1024, fo)) 
		fputs(buffer, ft);

	fclose(ft);
	fclose(fo);
	fclose(fp);

	exit(0);
}

void output(char *input, FILE *fp) {
	char *fields[5] = { 0, 0, 0, 0, 0 };
	int i;

	for(i = 0; i < 5; i++) {
		if(!(fields[i] = strsep(&input, " \t")))
			break;

		if(fields[i][0] == '-' || fields[i][0] == '\0')
			fields[i] = NULL;
	}


	if(!fields[0] || !fields[1]) {
		fprintf(stderr, "Error in table line %d\n", Line);
		return;
	}
	
	if(fields[4]) 
		fprintf(fp, "#ifdef %s\n", fields[4]);

	if(fields[3])
		fprintf(fp, "#include \"%s\"\n", fields[3]);

	fprintf(fp, "\t{ \"%s\",\t%s,\t%s\t },\n",
		fields[0], fields[2] ? fields[2] : "NULL", fields[1]);

	if(fields[4])
		fprintf(fp, "#endif /* %s */\n", fields[4]);

	return;
}

char *strsc(char *string) {
        int x = 0;
        int y = 0;
        
        if(!strlen(string))
                return(string);
         
        while(string[x]) {
                if(isspace(string[x])) {
                        if(y && string[x + 1])
                                string[y++] = ' ';
 
                        while(isspace(string[x]))
                                x++;
                } else
                        string[y++] = string[x++];
        }

                
        string[y] = '\0';
        return(string);
}

