/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#include "casl.h"

/* For hosts that don't have then defined.
*/

#if !defined(_FREEBSD) && !defined(_OPENBSD) && !defined(_SUNOS5)
char *
ether_ntoa(struct ether_addr *e)
{
	static char tmpbuf[sizeof "xx:xx:xx:xx:xx:xx"];
    	u_char *o = e->octet;

    	sprintf(tmpbuf, "%02x:%02x:%02x:%02x:%02x:%02x",
        		o[0], o[1], o[2], o[3], o[4], o[5]);
	return tmpbuf;
}

struct ether_addr *
ether_aton(char *s)
{
    	static struct ether_addr addr;
    	u_char *o = addr.octet;
	int i[6];

    	if(sscanf(s, "%x:%x:%x:%x:%x:%x", &i[0], &i[1], &i[2], 
			&i[3], &i[4], &i[5]) != 6) {
		return 0;
	}
	o[0] = i[0];
	o[1] = i[1];
	o[2] = i[2];
	o[3] = i[3];
	o[4] = i[4];
	o[5] = i[5];
	return &addr;
}
#endif

