#!/bin/sh
#
# CASL Installation Script
# 

EXE=
OS=`uname`
if [ "$OS" = "SunOS" ]; then
	DIR="/opt/casl"
	ECHO="/usr/ucb/echo"
elif [ "$OS" = "CYGWIN32_NT" ]; then
	DIR="/Program Files/casl"
	ECHO="echo"
        EXE=.exe
else
	DIR="/usr/local/casl"
	ECHO="/bin/echo"
fi

echo
echo "Please enter a directory where you would like to install"
echo "the CASL language distribution, or hit ENTER to install" 
echo "into the default directory ($DIR)."
echo
$ECHO -n "Destination [$DIR]: "
read IDIR
if [ ! "$IDIR" = "" ]; then
	DIR="$IDIR"
	echo
	echo Please note that you must now set your environment to 
	echo point the variable "CASL_DIR" to the directory you have
	echo just specified.
	echo
	$ECHO -n "Hit ENTER to continue"
	read FOO
fi

if [ -d "$DIR" ]; then
	$ECHO -n "$DIR already exists.  Overwrite? [n]: "
	read ANS
	case $ANS in
	y*|Y*) ;;
	*)
		echo "Installation cancelled."
		exit 1
		;;
	esac
fi

INCLUDE="$DIR/include"
BINS="$DIR/bin"
DOX="$DIR/doc"
EXAMPLES="$DIR/examples"

if [ ! -d $DIR ]; then
	echo "Creating $DIR"
	mkdir "$DIR"
	chmod 755 "$DIR"
fi
if [ ! -d $INCLUDE ]; then
	echo "Creating $INCLUDE"
	mkdir "$INCLUDE"
	chmod 755 "$INCLUDE"
fi
if [ ! -d $BINS ]; then
	echo "Creating $BINS"
	mkdir "$BINS"
	chmod 755 "$BINS"
fi
if [ ! -d $EXAMPLES ]; then
	echo "Creating $EXAMPLES"
	mkdir "$EXAMPLES"
	chmod 755 "$EXAMPLES"
fi
if [ ! -d $DOX ]; then
	echo "Creating $DOX"
	mkdir "$DOX"
	chmod 755 "$DOX"
fi

echo "Installing Configuration Files"
cp include/casl-config-master.casl "$INCLUDE"
cp casl.conf "$DIR"

echo "Installing Binaries"
cp casl$EXE "$BINS"
cp cpp$EXE "$BINS"
chmod 755 "$BINS"/* 

echo "Installing Include Files"
cp include/*.casl "$INCLUDE"
chmod 644 "$INCLUDE"/*

echo "Installing Example Source"
cp examples/* "$EXAMPLES"
chmod 755 "$EXAMPLES"/*

echo "Installing Documentation"
cp CASL.PDF "$DOX"
cp LICENSE.TXT "$DOX"
cp WHATSNEW.TXT "$DOX"
cp CREDITS.TXT "$DOX"
chmod 644 "$DOX"/*

echo
echo
echo 
echo 
echo
echo "If you have multiple ethernet interfaces, you may need to edit"
echo "the CASL configuration at $DIR/casl.conf to explicitly tell CASL"
echo "what interface to use."
