/* csum.c
	Computes the standard internet checksum of a set of data
	from RFC1071
*/

#define __USE_BSD    /* GLIBC */
#define _BSD_SOURCE  /* LIBC5 */
#include <sys/types.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <string.h>
#include <stdlib.h>

unsigned short csum (unsigned short *packet, int packlen);
unsigned short tcpcsum (unsigned char *iphdr, unsigned short *packet,
								int packlen);

/* Checksum a block of data */
unsigned short csum (unsigned short *packet, int packlen) {
	register unsigned long sum = 0;

	while (packlen > 1) {
		sum+= *(packet++);
		packlen-=2;
	}

	if (packlen > 0)
		sum += *(unsigned char *)packet;

	/* TODO: this depends on byte order */

	while (sum >> 16)
		sum = (sum & 0xffff) + (sum >> 16);

	return (unsigned short) ~sum;
}

/* Create tcp pseudo-header, and use that + tcp packet to build the csum */
unsigned short tcpcsum (unsigned char *iphdr, unsigned short *packet,
								int packlen) {
	unsigned short *buf;
	unsigned short res;

	buf = malloc(packlen+12);
	if(buf == NULL) return 0;

	memcpy(buf,iphdr+12,8); /* Source and destination addresses */
	*(buf+4)=htons((unsigned short)(*(iphdr+9)));
	*(buf+5)=htons((unsigned short)packlen);
	memcpy(buf+6,packet,packlen);

	res = csum(buf,packlen+12);
	free(buf);
	return res;
}
