/*
** xipvar.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 08:30:04 1999 
** Last update Thu Oct 28 20:24:24 1999 
*/
#ifndef XIPCF_H
#define XIPCF_H	1

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XmgFancy.h"
#include "mg.h"
#include "pat_ether.h"
#include "pat_ip.h"
#include "pat_inaddr.h"
#include "pat_ethaddr.h"
#include "pat_8.h"
#include "pat_16.h"
#include "pat_32.h"
#include "pat_subnet.h"

typedef struct			s_xip_var
{
  char				*name;			/* must be static */
  t_off				offset;
  size_t			size;	
  t_pat				*pat;
  VOID_PTR			data;
} t_xip_var;

#define NULL_XIP_VAR		{NULL,0,0,NULL,NULL}

extern char			*tmpl_buf;
extern char			*html_buf;
extern char			*htmlize_buf;
extern t_u32			tmpl_bufsiz;
extern t_u32			html_bufsiz;
extern t_u32			htmlize_bufsiz;
extern struct in_addr		my_ip;
extern t_ether_addr		my_ether;
extern t_u16			ip_id;

typedef struct			s_xip_cf_box_entry
{
  char				*widget_name;
  char				*var;
} t_xip_cf_box_entry;

#define NULL_XIP_CF_BOX_ENTRY	{NULL,NULL}

typedef struct			s_xip_cf_box_group
{
  char				*widget_name;	/* must be static */
  char				*label;		/* must be static */
  t_xip_cf_box_entry		*entries;	/* must be static */
} t_xip_cf_box_group;

#define NULL_XIP_CF_BOX_GROUP	{NULL,NULL,NULL}

typedef t_status		(*t_xip_plugin_proc) P((VOID_DECL));

/* PROTO xipvar.c */
/* xipvar.c */
t_status memoryzone_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status memoryzone_pat_insert P((void *data, char *buf, int len, char *value));
t_status plugins_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status plugins_pat_extract P((void *data, char *buf, int len, char *str, int max_len));
t_status plugins_pat_insert P((void *data, char *buf, int len, char *value));
void xip_debug_init P((void));
t_status xip_var_add P((t_xip_var *xv));
t_status xip_vars_init P((void));
void xip_vars_destroy P((void));
t_xip_var *xip_var_get_from_name P((char *name));
t_status xip_var_set P((char *name, char *value));
t_status xip_var_get P((char *name, char *str, int max_len));
t_status xip_cf_save P((char *fname));
int xip_cf_load_cmp P((void **p1, void **p2));
t_status xip_cf_load_walk P((t_hash_elt *he, void *unused));
t_status xip_cf_load P((char *fname));
void XipCfCancelCommand P((Widget w, Widget shell, void *cbs));
char *xip_var_get_static P((char *var));
void XipCfOkCommand P((Widget w, Widget shell, void *cbs));
t_status xip_cf_box_group_add P((t_xip_cf_box_group *xcbg));
t_status xip_cf_box_groups_init P((void));
void xip_cf_box_groups_destroy P((void));
void XipCreateCfBox P((Widget parent));
#endif
