/*
** xippkt.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 08:30:26 1999 
** Last update Thu Oct 28 20:24:35 1999 
*/
#ifndef XIPPKT_H
#define XIPPKT_H	1

#include <X11/Intrinsic.h>
#include "XmgFancy.h"
#include "xip.h"
#include "pkt.h"

typedef struct		s_xip_pkt
{
  t_pkt			*pkt;
  Widget		shell;
  Widget		fancy;
  t_vec			*users;
  t_boolean		do_opts;
  t_boolean		own_pkt;
  t_boolean		in_delete;
} t_xip_pkt;

typedef struct		s_xip_method_data
{
  t_xip_pkt		*xp;
  t_boolean		new_window;
  VOID_PTR		data;
} t_xip_method_data;

typedef t_status	(*t_xip_method_proc) P((t_xip_method_data *xmd,
						 t_vec *args));

typedef struct		s_xip_method
{
  char			*name;			/* must be static */
  t_xip_method_proc	proc;
} t_xip_method;

typedef struct		s_xip_pkt_bar
{
  char			*label;			/* must be static */
  char			*methodstr;		/* must be static */
} t_xip_pkt_bar;

/* PROTO xippkt.c */
/* xippkt.c */
t_status xip_pkt_delete P((t_xip_pkt *xp));
t_status xip_method_proc_delete P((t_xip_method_data *xmd, t_vec *args));
void set_prompt_ok P((Widget w, t_vec *vec, XtPointer cbs));
void set_prompt_pulldown_ok P((Widget w, t_vec *vec, XtPointer cbs));
void set_prompt_cancel P((Widget w, t_vec *vec, XtPointer cbs));
t_status xip_method_proc_set_args_eq_2 P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_set P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_extract P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_extract_to_pkt_box P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_trunc P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_save P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_load P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_sum P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_adapt_len P((t_xip_method_data *xmd, t_vec *args));
t_status xip_pkt_cut_init P((void));
void xip_pkt_cut_destroy P((void));
t_status xip_method_proc_cut P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_paste P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_edit P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_reply P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_custom P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_opts P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_view_tmpl P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_proc_view_tree_walk P((t_pkt *pkt, int level, t_id *id, void *data));
t_status xip_method_proc_view_tree P((t_xip_method_data *xmd, t_vec *args));
t_status xip_method_add P((t_xip_method *xm));
t_status xip_methods_init P((void));
void xip_methods_destroy P((void));
void xip_method_do P((t_xip_method_data *xmd, t_vec *args));
void xip_method_parse P((t_xip_method_data *xmd, char *str));
void XipPktFancyLink P((Widget w, t_xip_pkt *xp, XmgFancyLinkCallbackStruct *cbs));
void bsb_table P((Widget w, void *closure, void *cbs));
void XipPktFancyTitle P((Widget w, t_xip_pkt *xp, XmgFancyTitleCallbackStruct *cbs));
void XipPktDestroy P((Widget w, t_xip_pkt *xp, void *cbs));
t_status xip_pkt_bar_add P((t_xip_pkt_bar *xpb));
t_status xip_pkt_bar_init P((void));
void xip_pkt_bar_destroy P((void));
t_status xip_pkt_tmpl P((t_pkt *pkt, t_boolean do_opts, char *str, int max_len));
t_status xip_pkt_html P((t_pkt *pkt, t_boolean do_opts, char *str, int max_len));
Widget XipCreatePkt P((Widget parent, t_pkt *pkt, t_boolean own_pkt));
#endif
