/*
** pat_udp.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:46:34 1999 
** Last update Thu Oct 28 20:20:52 1999 
*/
#ifndef PAT_UDP_H
#define PAT_UDP_H	1

#include "pat.h"

typedef struct		s_udp
{
  t_u16			sport;
  t_u16			dport;
  t_u16			ulen;
  t_u16			sum;
} t_udp;

#define UDP_HLEN	8
#define UDP_ALEN	4

/*
** - packet len is IP_HLEN + UDP_HLEN + data_len
** - sport + dport are unsigned short
*/

#define PAT_UDP_CHECK(udppar,bufpar,lenpar) \
	if ((lenpar) < UDP_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(udppar) = (t_udp *)(bufpar);

extern t_boolean	pat_udp_perform_sum;
extern t_boolean	pat_udp_guess_mode;
extern t_id		*pat_udp_sub_id;

extern t_pat		udp_pat;

/* PROTO pat_udp.c */
/* pat_udp.c */
t_status pat_udp_init P((void));
void pat_udp_destroy P((void));
t_u16 udp_cksum P((struct s_ip *ip));
void udp_compute_sum P((struct s_ip *ip));
void udp_set_proto P((t_ip *ip));
void udp_set_sport P((t_udp *udp, int sport));
int udp_get_sport P((t_udp *udp));
void udp_set_dport P((t_udp *udp, int dport));
int udp_get_dport P((t_udp *udp));
void udp_set_ulen P((t_udp *udp, int ulen));
int udp_get_ulen P((t_udp *udp));
void udp_set_sum P((t_udp *udp, int sum));
int udp_get_sum P((t_udp *udp));
t_status udp_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status udp_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status udp_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status udp_pat_get_fields P((void *data, t_vec *vec_str));
t_status udp_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status udp_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status udp_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status udp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status udp_zero_sum P((char *buf, int len, char *up_buf, int up_len));
t_status udp_pat_sum P((void *data, char *buf, int len, char *up_buf, int up_len));
t_status udp_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status udp_pat_adapt_len P((void *data, char *buf, int len));
#endif
