/*
** pat_tcp.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:47:06 1999 
** Last update Thu Oct 28 20:20:57 1999 
*/
#ifndef PAT_TCP_H
#define PAT_TCP_H	1

#include "pat.h"
#include "pat_ip.h"

#define TCPOPT_EOOL	0
#define TCPOPT_NOP	1
#define TCPOPT_MSS	2
#define TCPOPT_WIN	3
#define TCPOPT_TS	8

extern t_assoc		tcpopt_assocs[];

typedef t_u32		t_tcp_seq;

typedef struct		s_tcp 
{
  t_u16			sport;
  t_u16			dport;
#define TCP_SEQACK_OFF		4
  t_tcp_seq		seq; 
  t_tcp_seq		ack; 
  t_u8			offx2;	
  t_u8			flags;
  t_u16			win;
  t_u16			sum;
  t_u16			urp;
} t_tcp;

#define TCP_MAXWIN	65535

#define TCP_MINHLEN	20
#define TCP_MAXHLEN	(15 * 4)

#define PAT_TCP_CHECK(tcppar,bufpar,lenpar) \
	if ((lenpar) < TCP_MINHLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(tcppar) = (t_tcp *)(bufpar);

#define TCP_FIN		0x01
#define TCP_SYN		0x02
#define TCP_RST		0x04
#define TCP_PUSH	0x08
#define TCP_ACK		0x10
#define TCP_URG		0x20

extern t_mask_def	tcpflags_mask_defs[];

extern t_pat		tcpoptdata_pat;
extern t_pat		tcpopt_pat;
extern t_pat		tcp_pat;

/* PROTO pat_tcp.c */
/* pat_tcp.c */
t_status tcpoptdata_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status tcpoptdata_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_field *tcpopt_get_fields P((char *buf, int len, t_status *status));
char *tcpopt_get_itmpl P((char *buf, int len, t_status *status));
t_status tcpopt_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status tcpopt_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status tcpopt_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status tcpopt_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status tcpopt_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status tcpopt_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status tcpopt_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status tcpopt_pat_has_opt P((void *data, char *buf, int len, t_boolean *has_opt_return, t_off *opt_off_return, int *opt_len_return, t_pat **opt_pat_return, void **opt_data_return));
t_u16 tcp_cksum P((t_ip *ip));
void tcp_compute_sum P((t_ip *ip));
void tcp_set_proto P((t_ip *ip));
void tcp_set_sport P((t_tcp *tcp, int sport));
int tcp_get_sport P((t_tcp *tcp));
void tcp_set_dport P((t_tcp *tcp, int dport));
int tcp_get_dport P((t_tcp *tcp));
void tcp_set_seq P((t_tcp *tcp, t_tcp_seq seq));
t_tcp_seq tcp_get_seq P((t_tcp *tcp));
void tcp_set_ack P((t_tcp *tcp, t_tcp_seq ack));
t_tcp_seq tcp_get_ack P((t_tcp *tcp));
void tcp_set_off P((t_tcp *tcp, int off));
int tcp_get_off P((t_tcp *tcp));
void tcp_set_x2 P((t_tcp *tcp, int x2));
int tcp_get_x2 P((t_tcp *tcp));
void tcp_set_flags P((t_tcp *tcp, int flags));
int tcp_get_flags P((t_tcp *tcp));
void tcp_set_win P((t_tcp *tcp, int win));
int tcp_get_win P((t_tcp *tcp));
void tcp_set_sum P((t_tcp *tcp, int sum));
int tcp_get_sum P((t_tcp *tcp));
void tcp_set_urp P((t_tcp *tcp, int urp));
int tcp_get_urp P((t_tcp *tcp));
t_status tcp_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status tcp_pat_get_fields P((void *data, t_vec *vec_str));
t_status tcp_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status tcp_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status tcp_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status tcp_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status tcp_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status tcp_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status tcp_pat_sum P((void *data, char *buf, int len, char *up_buf, int up_len));
t_status tcp_pat_has_opt P((void *data, char *buf, int len, t_boolean *has_opt_return, t_off *opt_off_return, int *opt_len_return, t_pat **opt_pat_return, void **opt_data_return));
#endif
