/*
** pat_shortbuf.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:41:24 1999 
** Last update Thu Oct 28 20:19:38 1999 
*/
#include "pat.h"
#include "pat_data.h"
#include "pat_16.h"
#include "pat_shortbuf.h"

char			*shortbuf_itmpl = "\n\
<table _name=shortbuf[%i%] bgcolor=\"%%shortbufColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<small>\n\
<a href=\"set(shortbuf[%i%].len)\">%%shortbuf[%i%].len%%</a> byte(s)\n\
</td>\n\
<td align=center>\n\
<code>\n\
<a href=\"set(shortbuf[%i%].buf)\">%%shortbuf[%i%].buf%%</a>\n\
</code>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

t_field			shortbuf_fields[] = 
{
  {"len",        0,      &nu16_pat,		NULL},
  {"buf",        0,      &shortbuf_pat,		NULL},
  NULL_FIELD
};

int	shortbuf_chan;

PAT_NAME_GENERIC(shortbuf_pat_name,
		 (VOID_PTR)&shortbuf_chan,
		 "shortbuf")

PAT_GET_FIELD_GENERIC(shortbuf_pat_get_field,
		      shortbuf_fields)

PAT_SET_FIELD_GENERIC(shortbuf_pat_set_field,
		      shortbuf_fields)

PAT_GET_FIELDS_GENERIC(shortbuf_pat_get_fields,
		       shortbuf_fields)

PAT_GET_TMPL_GENERIC(shortbuf_pat_get_tmpl,
		     (VOID_PTR)&shortbuf_chan,
		     shortbuf_itmpl)

PAT_GET_FIELD_PAT_GENERIC(shortbuf_pat_get_field_pat,
			  shortbuf_fields)

PAT_SUB_GENERIC(shortbuf_pat_sub,
		&shortbuf_pat)

PAT_EXTRACT_DECL(shortbuf_pat_extract)
{
  t_u16		my_len;
  
  if (len < 2)
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&my_len,sizeof (my_len));
  my_len = UNSAFE_NTOHS(my_len);
  if (len < (2 + my_len))
    return (ERR_PAT_TRUNC_FIELD);
  return (buf_to_xdata_str(buf + 2,
			   my_len,
			   pat_data_bytes_per_line,
			   "\n",
			   " ",
			   str,
			   max_len));
}

PAT_INSERT_DECL(shortbuf_pat_insert)
{
  t_status	status;	
  int		ilen;
  char		my_buf[BUFSIZ];
  t_u16		my_len;
  
  if ((status = xdata_to_buf(value,
			     my_buf,
			     &ilen,
			     sizeof (my_buf))) != 0)
    return (status);
  if (ilen > 65535)
    return (ERR_PAT_TOO_BIG);
  if (len < (ilen + 2))
    return (ERR_PAT_TRUNC_FIELD);
  my_len = UNSAFE_HTONS((t_u16)ilen);
  FBCOPY(&my_len,buf,sizeof (my_len));
  bcopy(my_buf,buf + 2,ilen);
  return (0);
}

PAT_OFF_DECL(shortbuf_pat_off)
{
  t_u16		my_len;
  
  if (len < 2)
    return (ERR_PAT_TRUNC_PAT);
  FBCOPY(buf,&my_len,sizeof (my_len));
  my_len = UNSAFE_NTOHS(my_len);
  (*off_return) = my_len + 2;
  return (0);
}

t_pat				shortbuf_pat = 
{
  shortbuf_pat_name,		/* t_pat_name_proc		*/
  shortbuf_pat_off,		/* t_pat_off_proc		*/
  shortbuf_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  shortbuf_pat_get_field,	/* t_pat_get_field_proc		*/
  shortbuf_pat_set_field,	/* t_pat_set_field_proc		*/
  shortbuf_pat_get_fields,	/* t_pat_get_fields_proc	*/
  shortbuf_pat_get_tmpl,	/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  shortbuf_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  shortbuf_pat_extract,		/* t_pat_extract_proc		*/
  shortbuf_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
