/*
** pat_rip.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:42:00 1999 
** Last update Thu Oct 28 20:19:44 1999 
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "pat_rip.h"
#include "pat_ip.h"
#include "pat_ether.h"
#include "pat_data.h"
#include "pat_32.h"
#include "pat_16.h"
#include "pat_8.h"
#include "pat_inaddr.h"

t_assoc			family_assocs[] =
{
  {"unspec",		(VOID_PTR)AF_UNSPEC},               
  {"unix",		(VOID_PTR)AF_UNIX},               
  {"inet",		(VOID_PTR)AF_INET},               
  {NULL,		0},
};

t_field				ripinfo_fields[] = 
{
  {"family",	OFFSET(t_ripinfo *,family),	&nu16_pat,		NULL},
  {"Family",	OFFSET(t_ripinfo *,family),  &nu16assoc_pat,	family_assocs},
  {"tag",	OFFSET(t_ripinfo *,tag),	&nu16_pat,		NULL},
  {"dst",	OFFSET(t_ripinfo *,dst),	&inaddr_pat,		NULL},
  {"Dst",	OFFSET(t_ripinfo *,dst),	&inaddr_resolved_pat,	NULL},
  {"mask",	OFFSET(t_ripinfo *,mask),	&inaddr_pat,		NULL},
  {"Mask",	OFFSET(t_ripinfo *,mask),	&inaddr_resolved_pat,	NULL},
  {"router",	OFFSET(t_ripinfo *,router),	&inaddr_pat,		NULL},
  {"Router",	OFFSET(t_ripinfo *,router),	&inaddr_resolved_pat,	NULL},
  {"metric",	OFFSET(t_ripinfo *,metric),	&nu32_pat,		NULL},
  NULL_FIELD
};

char				*ripinfo_itmpl = "\n\
<table _name=ripinfo[%i%] width=100%%%% bgcolor=\"%%ripinfoColor%%\">\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<a href=\"set(ripinfo[%i%].Family)\">%%ripinfo[%i%].Family%%</a>\n\
(<a href=\"set(ripinfo[%i%].family)\">%%ripinfo[%i%].family%%</a>)\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"set(ripinfo[%i%].tag)\">%%ripinfo[%i%].tag%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(ripinfo[%i%].Dst)\">%%ripinfo[%i%].Dst%%</a>\n\
(<a href=\"set(ripinfo[%i%].dst)\">%%ripinfo[%i%].dst%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(ripinfo[%i%].Mask)\">%%ripinfo[%i%].Mask%%</a>\n\
(<a href=\"set(ripinfo[%i%].mask)\">%%ripinfo[%i%].mask%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(ripinfo[%i%].Router)\">%%ripinfo[%i%].Router%%</a>\n\
(<a href=\"set(ripinfo[%i%].router)\">%%ripinfo[%i%].router%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(ripinfo[%i%].metric)\">%%ripinfo[%i%].metric%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	ripinfo_chan;

PAT_NAME_GENERIC(ripinfo_pat_name,
		 (VOID_PTR)&ripinfo_chan,
		 "ripinfo")

PAT_GET_FIELD_GENERIC(ripinfo_pat_get_field,
		      ripinfo_fields)

PAT_SET_FIELD_GENERIC(ripinfo_pat_set_field,
		      ripinfo_fields)

PAT_GET_FIELDS_GENERIC(ripinfo_pat_get_fields,
		       ripinfo_fields)

PAT_GET_FIELD_PAT_GENERIC(ripinfo_pat_get_field_pat,
			  ripinfo_fields)

PAT_GET_TMPL_GENERIC(ripinfo_pat_get_tmpl,
		     (VOID_PTR)&ripinfo_pat,
		     ripinfo_itmpl)

PAT_OFF_GENERIC(ripinfo_pat_off,
		RIPINFO_HLEN)

PAT_SUB_GENERIC(ripinfo_pat_sub,
		&ripinfo_pat)

t_pat				ripinfo_pat = 
{
  ripinfo_pat_name,		/* t_pat_name_proc		*/
  ripinfo_pat_off,		/* t_pat_off_proc		*/
  ripinfo_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  ripinfo_pat_get_field,	/* t_pat_get_field_proc		*/
  ripinfo_pat_set_field,	/* t_pat_set_field_proc		*/
  ripinfo_pat_get_fields,	/* t_pat_get_fields_proc	*/
  ripinfo_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  ripinfo_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

t_assoc				ripcmd_assocs[] =
{
  {"request",			(VOID_PTR)1},
  {"response",			(VOID_PTR)2},
  {"traceon",			(VOID_PTR)3},
  {"traceoff",			(VOID_PTR)4},
  {"poll",			(VOID_PTR)5},
  {"pollentry",			(VOID_PTR)6},
  {NULL,			NULL},
};

t_field				rip_fields[] = 
{
  {"cmd",	OFFSET(t_rip *,cmd),	&u8_pat,		NULL},
  {"Cmd",	OFFSET(t_rip *,cmd),	&u8assoc_pat,  ripcmd_assocs},
  {"v",		OFFSET(t_rip *,v),	&u8_pat,		NULL},
  {"mbz",	OFFSET(t_rip *,mbz),	&nu16_pat,		NULL},
  NULL_FIELD
};

char				*rip_itmpl = "\n\
<table _name=rip[%i%] width=100%%%% bgcolor=\"%%ripColor%%\">\n\
<tr>\n\
<td align=center width=25%%%%>\n\
<a href=\"set(rip[%i%].Cmd)\">%%rip[%i%].Cmd%%</a>\n\
(<a href=\"set(rip[%i%].cmd)\">%%rip[%i%].cmd%%</a>)\n\
</td>\n\
<td align=center width=25%%%%>\n\
<a href=\"set(rip[%i%].v)\">%%rip[%i%].v%%</a>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"set(rip[%i%].mbz)\">%%rip[%i%].mbz%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	rip_chan;

PAT_NAME_GENERIC(rip_pat_name,
		 (VOID_PTR)&rip_chan,
		 "rip")

PAT_GET_FIELD_GENERIC(rip_pat_get_field,
		      rip_fields)

PAT_SET_FIELD_GENERIC(rip_pat_set_field,
		      rip_fields)

PAT_GET_FIELDS_GENERIC(rip_pat_get_fields,
		       rip_fields)

PAT_GET_FIELD_PAT_GENERIC(rip_pat_get_field_pat,
			  rip_fields)

PAT_GET_TMPL_GENERIC(rip_pat_get_tmpl,
		     (VOID_PTR)&rip_pat,
		     rip_itmpl)

PAT_OFF_GENERIC(rip_pat_off,
		RIP_HLEN)

PAT_SUB_GENERIC(rip_pat_sub,
		&ripinfo_pat)

t_pat				rip_pat = 
{
  rip_pat_name,			/* t_pat_name_proc		*/
  rip_pat_off,			/* t_pat_off_proc		*/
  rip_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  rip_pat_get_field,		/* t_pat_get_field_proc		*/
  rip_pat_set_field,		/* t_pat_set_field_proc		*/
  rip_pat_get_fields,		/* t_pat_get_fields_proc	*/
  rip_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  rip_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
