/*
** pat_mac.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:42:36 1999 
** Last update Thu Oct 28 20:19:53 1999 
*/
#include "pat_mac.h"
#include "pat_ethaddr.h"
#include "pat_ether.h"

/* Taken from www.netsys.com */

t_mac		macs[] = 
{
  {0x00,0x00,0x02,MAC_ANY,MAC_ANY,MAC_ANY,"BBN"},
  {0x00,0x00,0x0C,MAC_ANY,MAC_ANY,MAC_ANY,"Cisco"},
  {0x00,0x00,0x0E,MAC_ANY,MAC_ANY,MAC_ANY,"Fujitsu"},
  {0x00,0x00,0x0F,MAC_ANY,MAC_ANY,MAC_ANY,"NeXt"},
  {0x00,0x00,0x10,MAC_ANY,MAC_ANY,MAC_ANY,"Hughes-LAN-Sytdek"},
  {0x00,0x00,0x11,MAC_ANY,MAC_ANY,MAC_ANY,"Tektronix"},
  {0x00,0x00,0x15,MAC_ANY,MAC_ANY,MAC_ANY,"Datapoint-Corporation"}, 
  {0x00,0x00,0x18,MAC_ANY,MAC_ANY,MAC_ANY,"Webster"},
  {0x00,0x00,0x1A,MAC_ANY,MAC_ANY,MAC_ANY,"AMD"},
  {0x00,0x00,0x1B,MAC_ANY,MAC_ANY,MAC_ANY,"Novell-Eagle-Technology"},
  {0x00,0x00,0x1D,MAC_ANY,MAC_ANY,MAC_ANY,"Cabletron"},
  {0x00,0x00,0x20,MAC_ANY,MAC_ANY,MAC_ANY,"DIAB"},
  {0x00,0x00,0x21,MAC_ANY,MAC_ANY,MAC_ANY,"SC&C"},
  {0x00,0x00,0x22,MAC_ANY,MAC_ANY,MAC_ANY,"Visual-Technology"},
  {0x00,0x00,0x29,MAC_ANY,MAC_ANY,MAC_ANY,"IMC"},
  {0x00,0x00,0x2A,MAC_ANY,MAC_ANY,MAC_ANY,"TRW"},
  {0x00,0x00,0x3C,MAC_ANY,MAC_ANY,MAC_ANY,"Auspex"},
  {0x00,0x00,0x3D,MAC_ANY,MAC_ANY,MAC_ANY,"AT&T"},
  {0x00,0x00,0x44,MAC_ANY,MAC_ANY,MAC_ANY,"Castelle"},
  {0x00,0x00,0x46,MAC_ANY,MAC_ANY,MAC_ANY,"ISC-Bunker-Ramo"},
  {0x00,0x00,0x49,MAC_ANY,MAC_ANY,MAC_ANY,"Apricot"},
  {0x00,0x00,0x4B,MAC_ANY,MAC_ANY,MAC_ANY,"APT"},
  {0x00,0x00,0x4F,MAC_ANY,MAC_ANY,MAC_ANY,"Logicraft-386-Ware"},
  {0x00,0x00,0x52,MAC_ANY,MAC_ANY,MAC_ANY,"ODS"},
  {0x00,0x00,0x55,MAC_ANY,MAC_ANY,MAC_ANY,"AT&T"},
  {0x00,0x00,0x5A,MAC_ANY,MAC_ANY,MAC_ANY,"Schneider-Koch"},
  {0x00,0x00,0x5D,MAC_ANY,MAC_ANY,MAC_ANY,"RCE"},
  {0x00,0x00,0x5E,MAC_ANY,MAC_ANY,MAC_ANY,"IANA"},
  {0x00,0x00,0x5F,MAC_ANY,MAC_ANY,MAC_ANY,"Sumitomo"},
  {0x00,0x00,0x62,MAC_ANY,MAC_ANY,MAC_ANY,"Honeywell"},
  {0x00,0x00,0x65,MAC_ANY,MAC_ANY,MAC_ANY,"Network General"},
  {0x00,0x00,0x69,MAC_ANY,MAC_ANY,MAC_ANY,"Silicon-Graphics"},
  {0x00,0x00,0x6B,MAC_ANY,MAC_ANY,MAC_ANY,"MIPS"},
  {0x00,0x00,0x6E,MAC_ANY,MAC_ANY,MAC_ANY,"Artisoft-Inc"},
  {0x00,0x00,0x77,MAC_ANY,MAC_ANY,MAC_ANY,"Interphase-Corporation"},
  {0x00,0x00,0x79,MAC_ANY,MAC_ANY,MAC_ANY,"Net-Ware"},
  {0x00,0x00,0x7A,MAC_ANY,MAC_ANY,MAC_ANY,"Ardent"},
  {0x00,0x00,0x7B,MAC_ANY,MAC_ANY,MAC_ANY,"Research-Machines"},
  {0x00,0x00,0x7D,MAC_ANY,MAC_ANY,MAC_ANY,"Harris"},
  {0x00,0x00,0x7F,MAC_ANY,MAC_ANY,MAC_ANY,"Linotronic"},
  {0x00,0x00,0x80,MAC_ANY,MAC_ANY,MAC_ANY,"Dowty-Network-Services"},
  {0x00,0x00,0x81,MAC_ANY,MAC_ANY,MAC_ANY,"Synoptics"},
  {0x00,0x00,0x84,MAC_ANY,MAC_ANY,MAC_ANY,"ADI-Systems-Inc"},
  {0x00,0x00,0x86,MAC_ANY,MAC_ANY,MAC_ANY,"Megahertz-Corporation"},
  {0x00,0x00,0x89,MAC_ANY,MAC_ANY,MAC_ANY,"Cayman-Systems"},
  {0x00,0x00,0x8E,MAC_ANY,MAC_ANY,MAC_ANY,"Jupiter-Solbourne"},
  {0x00,0x00,0x93,MAC_ANY,MAC_ANY,MAC_ANY,"Proteon"},
  {0x00,0x00,0x94,MAC_ANY,MAC_ANY,MAC_ANY,"Asante"},
  {0x00,0x00,0x95,MAC_ANY,MAC_ANY,MAC_ANY,"Sony-Tektronix"}, 
  {0x00,0x00,0x97,MAC_ANY,MAC_ANY,MAC_ANY,"Epoch"},
  {0x00,0x00,0x98,MAC_ANY,MAC_ANY,MAC_ANY,"Cross-Com"},
  {0x00,0x00,0x9F,MAC_ANY,MAC_ANY,MAC_ANY,"Ameristar-Technology"},
  {0x00,0x00,0xA0,MAC_ANY,MAC_ANY,MAC_ANY,"Sanyo-Electronics"},
  {0x00,0x00,0xA2,MAC_ANY,MAC_ANY,MAC_ANY,"Wellfleet"},
  {0x00,0x00,0xA3,MAC_ANY,MAC_ANY,MAC_ANY,"NAT"},
  {0x00,0x00,0xA4,MAC_ANY,MAC_ANY,MAC_ANY,"Acorn"},
  {0x00,0x00,0xA5,MAC_ANY,MAC_ANY,MAC_ANY,"Compatible-Systems-Corporation"}, 
  {0x00,0x00,0xA6,MAC_ANY,MAC_ANY,MAC_ANY,"Network-General"}, 
  {0x00,0x00,0xA7,MAC_ANY,MAC_ANY,MAC_ANY,"NCD"},
  {0x00,0x00,0xA9,MAC_ANY,MAC_ANY,MAC_ANY,"Network-Systems"},
  {0x00,0x00,0xAA,MAC_ANY,MAC_ANY,MAC_ANY,"Xerox"},
  {0x00,0x00,0xAC,MAC_ANY,MAC_ANY,MAC_ANY,"Apollo"},
  {0x00,0x00,0xAF,MAC_ANY,MAC_ANY,MAC_ANY,"Nuclear-Data"},
  {0x00,0x00,0xB0,MAC_ANY,MAC_ANY,MAC_ANY,"RND"},
  {0x00,0x00,0xB3,MAC_ANY,MAC_ANY,MAC_ANY,"CIMLinc"},
  {0x00,0x00,0xB4,MAC_ANY,MAC_ANY,MAC_ANY,"Edimax"},
  {0x00,0x00,0xB5,MAC_ANY,MAC_ANY,MAC_ANY,"Datability"},
  {0x00,0x00,0xB7,MAC_ANY,MAC_ANY,MAC_ANY,"Dove"},
  {0x00,0x00,0xBC,MAC_ANY,MAC_ANY,MAC_ANY,"Allen-Bradley"},
  {0x00,0x00,0xC0,MAC_ANY,MAC_ANY,MAC_ANY,"Western-Digital-SMC"},
  {0x00,0x00,0xC6,MAC_ANY,MAC_ANY,MAC_ANY,"HP-Intelligent-Networks-Operation"},
  {0x00,0x00,0xC8,MAC_ANY,MAC_ANY,MAC_ANY,"Altos"},
  {0x00,0x00,0xC9,MAC_ANY,MAC_ANY,MAC_ANY,"Emulex"},
  {0x00,0x00,0xD0,MAC_ANY,MAC_ANY,MAC_ANY,"Develcon-Electronics"},
  {0x00,0x00,0xD1,MAC_ANY,MAC_ANY,MAC_ANY,"Adaptec-Inc"},
  {0x00,0x00,0xD4,MAC_ANY,MAC_ANY,MAC_ANY,"Puredata"},
  {0x00,0x00,0xD7,MAC_ANY,MAC_ANY,MAC_ANY,"Dartmouth-College"},
  {0x00,0x00,0xD8,MAC_ANY,MAC_ANY,MAC_ANY,"Old-Novell-NE1000"},
  {0x00,0x00,0xDD,MAC_ANY,MAC_ANY,MAC_ANY,"Gould"},
  {0x00,0x00,0xDE,MAC_ANY,MAC_ANY,MAC_ANY,"Unigraph"},
  {0x00,0x00,0xE2,MAC_ANY,MAC_ANY,MAC_ANY,"Acer-Counterpoint"},
  {0x00,0x00,0xE8,MAC_ANY,MAC_ANY,MAC_ANY,"Accton-Technology-Corp"},
  {0x00,0x00,0xEE,MAC_ANY,MAC_ANY,MAC_ANY,"Network-Designers-Ltd"},
  {0x00,0x00,0xEF,MAC_ANY,MAC_ANY,MAC_ANY,"Alantec"},
  {0x00,0x00,0xF0,MAC_ANY,MAC_ANY,MAC_ANY,"Samsung"},
  {0x00,0x00,0xF3,MAC_ANY,MAC_ANY,MAC_ANY,"Gandalf-Data-Limited"},
  {0x00,0x00,0xF4,MAC_ANY,MAC_ANY,MAC_ANY,"Allied-Telesis-Inc"},
  {0x00,0x00,0xF6,MAC_ANY,MAC_ANY,MAC_ANY,"A.M.C"},
  {0x00,0x00,0xF8,MAC_ANY,MAC_ANY,MAC_ANY,"DEC"},
  {0x00,0x00,0xFD,MAC_ANY,MAC_ANY,MAC_ANY,"High-Level-Hardware"},
  {0x00,0x01,0x02,MAC_ANY,MAC_ANY,MAC_ANY,"BBN"},
  {0x00,0x01,0x43,MAC_ANY,MAC_ANY,MAC_ANY,"IEEE-802"},
  {0x00,0x01,0x63,MAC_ANY,MAC_ANY,MAC_ANY,"National-Datacomm-Corporation"},
  {0x00,0x01,0x68,MAC_ANY,MAC_ANY,MAC_ANY,"Wandel-Goltermann"},
  {0x00,0x01,0xC8,MAC_ANY,MAC_ANY,MAC_ANY,"Thomas-Conrad-Corp"},
  {0x00,0x40,0x0B,MAC_ANY,MAC_ANY,MAC_ANY,"Crescendo"},
  {0x00,0x40,0x10,MAC_ANY,MAC_ANY,MAC_ANY,"Sonic"},
  {0x00,0x40,0x15,MAC_ANY,MAC_ANY,MAC_ANY,"Ascom"},
  {0x00,0x40,0x27,MAC_ANY,MAC_ANY,MAC_ANY,"Sigma"},
  {0x00,0x40,0x2B,MAC_ANY,MAC_ANY,MAC_ANY,"TriGem"},
  {0x00,0x40,0x2F,MAC_ANY,MAC_ANY,MAC_ANY,"XDI"},
  {0x00,0x40,0x95,MAC_ANY,MAC_ANY,MAC_ANY,"Eagle-Technologies"},
  {0x00,0x40,0x9D,MAC_ANY,MAC_ANY,MAC_ANY,"Digiboard"},
  {0x00,0x40,0xC5,MAC_ANY,MAC_ANY,MAC_ANY,"Micom-Communications-Corp"},
  {0x00,0x40,0xC8,MAC_ANY,MAC_ANY,MAC_ANY,"Milan-Technology-Corp"},
  {0x00,0x40,0xFB,MAC_ANY,MAC_ANY,MAC_ANY,"Cascade-Communications-Corp"},
  {0x00,0x60,0x8C,MAC_ANY,MAC_ANY,MAC_ANY,"3COM"},
  {0x00,0x80,0x0F,MAC_ANY,MAC_ANY,MAC_ANY,"Standard-Microsystem-Corp"},
  {0x00,0x80,0x10,MAC_ANY,MAC_ANY,MAC_ANY,"Commodore"},
  {0x00,0x80,0x17,MAC_ANY,MAC_ANY,MAC_ANY,"PFU"},
  {0x00,0x80,0x19,MAC_ANY,MAC_ANY,MAC_ANY,"Dayna-Communications"},
  {0x00,0x80,0x1B,MAC_ANY,MAC_ANY,MAC_ANY,"Kodiak-Technology"},
  {0x00,0x80,0x21,MAC_ANY,MAC_ANY,MAC_ANY,"Newbridge-Networks-Corporation"},
  {0x00,0x80,0x24,MAC_ANY,MAC_ANY,MAC_ANY,"Kalpana"},
  {0x00,0x80,0x29,MAC_ANY,MAC_ANY,MAC_ANY,"Microdyne-Corporation"},
  {0x00,0x80,0x2D,MAC_ANY,MAC_ANY,MAC_ANY,"Xylogics"},
  {0x00,0x80,0x2E,MAC_ANY,MAC_ANY,MAC_ANY,"Plexcom-Inc"},
  {0x00,0x80,0x33,MAC_ANY,MAC_ANY,MAC_ANY,"Formation"},
  {0x00,0x80,0x34,MAC_ANY,MAC_ANY,MAC_ANY,"SMT-Goupil"},
  {0x00,0x80,0x35,MAC_ANY,MAC_ANY,MAC_ANY,"Technology-Works"},
  {0x00,0x80,0x3E,MAC_ANY,MAC_ANY,MAC_ANY,"Synernetics"},
  {0x00,0x80,0x3F,MAC_ANY,MAC_ANY,MAC_ANY,"Hyundai"},
  {0x00,0x80,0x51,MAC_ANY,MAC_ANY,MAC_ANY,"ADC-Fibermux"},
  {0x00,0x80,0x52,MAC_ANY,MAC_ANY,MAC_ANY,"Network-Professor"},
  {0x00,0x80,0x5C,MAC_ANY,MAC_ANY,MAC_ANY,"Agilis"},
  {0x00,0x80,0x7C,MAC_ANY,MAC_ANY,MAC_ANY,"FiberCom"},
  {0x00,0x80,0x87,MAC_ANY,MAC_ANY,MAC_ANY,"Okidata"},
  {0x00,0x80,0x8A,MAC_ANY,MAC_ANY,MAC_ANY,"Summit"},
  {0x00,0x80,0x8C,MAC_ANY,MAC_ANY,MAC_ANY,"Frontier-Software-Development"},
  {0x00,0x80,0x96,MAC_ANY,MAC_ANY,MAC_ANY,"HDS"},
  {0x00,0x80,0xA1,MAC_ANY,MAC_ANY,MAC_ANY,"Microtest"},
  {0x00,0x80,0xA3,MAC_ANY,MAC_ANY,MAC_ANY,"Lantronix"},
  {0x00,0x80,0xAD,MAC_ANY,MAC_ANY,MAC_ANY,"Telebit"},
  {0x00,0x80,0xB2,MAC_ANY,MAC_ANY,MAC_ANY,"Network-Equipment-Technologies"},
  {0x00,0x80,0xC0,MAC_ANY,MAC_ANY,MAC_ANY,"Penril"},
  {0x00,0x80,0xC2,MAC_ANY,MAC_ANY,MAC_ANY,"IEEE"},
  {0x00,0x80,0xC7,MAC_ANY,MAC_ANY,MAC_ANY,"Xircom"},
  {0x00,0x80,0xC8,MAC_ANY,MAC_ANY,MAC_ANY,"D-Link"},
  {0x00,0x80,0xD0,MAC_ANY,MAC_ANY,MAC_ANY,"Computer-Products-International"},
  {0x00,0x80,0xD3,MAC_ANY,MAC_ANY,MAC_ANY,"Shiva-Corporation"},
  {0x00,0x80,0xD4,MAC_ANY,MAC_ANY,MAC_ANY,"Chase-Ltd"},
  {0x00,0x80,0xD6,MAC_ANY,MAC_ANY,MAC_ANY,"Apple-mac-portable"},
  {0x00,0x80,0xD8,MAC_ANY,MAC_ANY,MAC_ANY,"Network-Peripherals"},
  {0x00,0x80,0xE3,MAC_ANY,MAC_ANY,MAC_ANY,"Coral"},
  {0x00,0x80,0xF1,MAC_ANY,MAC_ANY,MAC_ANY,"Opus"},
  {0x00,0x80,0xF7,MAC_ANY,MAC_ANY,MAC_ANY,"Zenith-Communication-products"},
  {0x00,0xAA,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"Intel"},
  {0x00,0xB0,0xD0,MAC_ANY,MAC_ANY,MAC_ANY,"Computer-Products-International"},
  {0x00,0xDD,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"Ungermann-Bass"},
  {0x00,0xDD,0x01,MAC_ANY,MAC_ANY,MAC_ANY,"Ungermann-Bass"},
  {0x00,0xDD,0x08,MAC_ANY,MAC_ANY,MAC_ANY,"Ungermann-Bass"},
  {0x02,0x04,0x06,MAC_ANY,MAC_ANY,MAC_ANY,"BBN"},
  {0x02,0x07,0x01,MAC_ANY,MAC_ANY,MAC_ANY,"Racal-Interlan"},
  {0x02,0x60,0x86,MAC_ANY,MAC_ANY,MAC_ANY,"Satelcom-(UK)"},
  {0x02,0x60,0x8C,MAC_ANY,MAC_ANY,MAC_ANY,"3COM"},
  {0x02,0xCF,0x1F,MAC_ANY,MAC_ANY,MAC_ANY,"PrimeEXL-SG-Masscomp"},
  {0x08,0x00,0x01,MAC_ANY,MAC_ANY,MAC_ANY,"Computer-Vision"},
  {0x08,0x00,0x02,MAC_ANY,MAC_ANY,MAC_ANY,"3COM-formerly-Bridge"},
  {0x08,0x00,0x03,MAC_ANY,MAC_ANY,MAC_ANY,"Advanced-Computer-Communications"},
  {0x08,0x00,0x05,MAC_ANY,MAC_ANY,MAC_ANY,"Symbolics"},
  {0x08,0x00,0x06,MAC_ANY,MAC_ANY,MAC_ANY,"Siemens-Nixdorf"},
  {0x08,0x00,0x07,MAC_ANY,MAC_ANY,MAC_ANY,"Apple-Computer"},
  {0x08,0x00,0x08,MAC_ANY,MAC_ANY,MAC_ANY,"BBN"},
  {0x08,0x00,0x09,MAC_ANY,MAC_ANY,MAC_ANY,"Hewlett-Packard"},
  {0x08,0x00,0x0A,MAC_ANY,MAC_ANY,MAC_ANY,"Nestar-Systems"},
  {0x08,0x00,0x0B,MAC_ANY,MAC_ANY,MAC_ANY,"Unisys"},
  {0x08,0x00,0x0D,MAC_ANY,MAC_ANY,MAC_ANY,"ICL"},
  {0x08,0x00,0x0E,MAC_ANY,MAC_ANY,MAC_ANY,"NCR"},
  {0x08,0x00,0x0F,MAC_ANY,MAC_ANY,MAC_ANY,"SMC"},
  {0x08,0x00,0x10,MAC_ANY,MAC_ANY,MAC_ANY,"AT&T"},
  {0x08,0x00,0x11,MAC_ANY,MAC_ANY,MAC_ANY,"Tektronix"},
  {0x08,0x00,0x14,MAC_ANY,MAC_ANY,MAC_ANY,"Excelan"}, 
  {0x08,0x00,0x17,MAC_ANY,MAC_ANY,MAC_ANY,"National-Semiconductor-Corp"},
  {0x08,0x00,0x1A,MAC_ANY,MAC_ANY,MAC_ANY,"Data-General"},
  {0x08,0x00,0x1B,MAC_ANY,MAC_ANY,MAC_ANY,"Data-General"},
  {0x08,0x00,0x1E,MAC_ANY,MAC_ANY,MAC_ANY,"Apollo"},
  {0x08,0x00,0x1F,MAC_ANY,MAC_ANY,MAC_ANY,"Sharp"},
  {0x08,0x00,0x20,MAC_ANY,MAC_ANY,MAC_ANY,"Sun"},
  {0x08,0x00,0x22,MAC_ANY,MAC_ANY,MAC_ANY,"NBI"},
  {0x08,0x00,0x23,MAC_ANY,MAC_ANY,MAC_ANY,"Matsushita-Denso"},
  {0x08,0x00,0x25,MAC_ANY,MAC_ANY,MAC_ANY,"CDC"},
  {0x08,0x00,0x26,MAC_ANY,MAC_ANY,MAC_ANY,"Norsk-Data"},
  {0x08,0x00,0x27,MAC_ANY,MAC_ANY,MAC_ANY,"PCS-Computer-Systems-GMBH"},
  {0x08,0x00,0x28,MAC_ANY,MAC_ANY,MAC_ANY,"TI"},
  {0x08,0x00,0x2B,MAC_ANY,MAC_ANY,MAC_ANY,"DEC"},
  {0x08,0x00,0x2E,MAC_ANY,MAC_ANY,MAC_ANY,"Metaphor"},
  {0x08,0x00,0x2F,MAC_ANY,MAC_ANY,MAC_ANY,"Prime-Computer"},
  {0x08,0x00,0x36,MAC_ANY,MAC_ANY,MAC_ANY,"Intergraph"},
  {0x08,0x00,0x37,MAC_ANY,MAC_ANY,MAC_ANY,"Fujitsu-Xerox"},
  {0x08,0x00,0x38,MAC_ANY,MAC_ANY,MAC_ANY,"Bull"},
  {0x08,0x00,0x39,MAC_ANY,MAC_ANY,MAC_ANY,"Spider-Systems"},
  {0x08,0x00,0x3B,MAC_ANY,MAC_ANY,MAC_ANY,"Torus-Systems"},
  {0x08,0x00,0x3E,MAC_ANY,MAC_ANY,MAC_ANY,"Motorola"},
  {0x08,0x00,0x41,MAC_ANY,MAC_ANY,MAC_ANY,"Digital-Comm-Associates"},
  {0x08,0x00,0x44,MAC_ANY,MAC_ANY,MAC_ANY,"DAVID-Systems-Inc"},
  {0x08,0x00,0x45,MAC_ANY,MAC_ANY,MAC_ANY,"Xylogics"},
  {0x08,0x00,0x46,MAC_ANY,MAC_ANY,MAC_ANY,"Sony"},
  {0x08,0x00,0x47,MAC_ANY,MAC_ANY,MAC_ANY,"Sequent"},
  {0x08,0x00,0x49,MAC_ANY,MAC_ANY,MAC_ANY,"Univation"},
  {0x08,0x00,0x4C,MAC_ANY,MAC_ANY,MAC_ANY,"Encore"},
  {0x08,0x00,0x4E,MAC_ANY,MAC_ANY,MAC_ANY,"BICC"},
  {0x08,0x00,0x51,MAC_ANY,MAC_ANY,MAC_ANY,"Experdata"},
  {0x08,0x00,0x56,MAC_ANY,MAC_ANY,MAC_ANY,"Stanford-University"},
  {0x08,0x00,0x58,MAC_ANY,MAC_ANY,MAC_ANY,"DECsystem-20"},
  {0x08,0x00,0x5A,MAC_ANY,MAC_ANY,MAC_ANY,"IBM"},
  {0x08,0x00,0x67,MAC_ANY,MAC_ANY,MAC_ANY,"Comdesign"},
  {0x08,0x00,0x68,MAC_ANY,MAC_ANY,MAC_ANY,"Ridge"},
  {0x08,0x00,0x69,MAC_ANY,MAC_ANY,MAC_ANY,"Silicon-Graphics"},
  {0x08,0x00,0x6A,MAC_ANY,MAC_ANY,MAC_ANY,"AT&T"},
  {0x08,0x00,0x6E,MAC_ANY,MAC_ANY,MAC_ANY,"Excelan"},
  {0x08,0x00,0x70,MAC_ANY,MAC_ANY,MAC_ANY,"Mitsubishi"},
  {0x08,0x00,0x74,MAC_ANY,MAC_ANY,MAC_ANY,"Casio"},
  {0x08,0x00,0x75,MAC_ANY,MAC_ANY,MAC_ANY,"Danish-Data-Elektronik"},
  {0x08,0x00,0x77,MAC_ANY,MAC_ANY,MAC_ANY,"Retix"},
  {0x08,0x00,0x79,MAC_ANY,MAC_ANY,MAC_ANY,"Silicon-Graphics"},
  {0x08,0x00,0x7C,MAC_ANY,MAC_ANY,MAC_ANY,"Vitalink"},
  {0x08,0x00,0x80,MAC_ANY,MAC_ANY,MAC_ANY,"XIOS"},
  {0x08,0x00,0x81,MAC_ANY,MAC_ANY,MAC_ANY,"Crosfield-Electronics"},
  {0x08,0x00,0x83,MAC_ANY,MAC_ANY,MAC_ANY,"Seiko-Denshi"}, 
  {0x08,0x00,0x86,MAC_ANY,MAC_ANY,MAC_ANY,"Imagen-QMS"},
  {0x08,0x00,0x87,MAC_ANY,MAC_ANY,MAC_ANY,"Xyplex"},
  {0x08,0x00,0x89,MAC_ANY,MAC_ANY,MAC_ANY,"Kinetics"},
  {0x08,0x00,0x8B,MAC_ANY,MAC_ANY,MAC_ANY,"Pyramid"},
  {0x08,0x00,0x8D,MAC_ANY,MAC_ANY,MAC_ANY,"Xyvision"},
  {0x08,0x00,0x8E,MAC_ANY,MAC_ANY,MAC_ANY,"Tandem"},
  {0x08,0x00,0x8F,MAC_ANY,MAC_ANY,MAC_ANY,"Chipcom-Corp"},
  {0x08,0x00,0x90,MAC_ANY,MAC_ANY,MAC_ANY,"Retix"},
  {0x10,0x00,0x5A,MAC_ANY,MAC_ANY,MAC_ANY,"IBM"},
  {0x10,0x00,0xD4,MAC_ANY,MAC_ANY,MAC_ANY,"DEC"},
  {0x10,0x00,0xE0,MAC_ANY,MAC_ANY,MAC_ANY,"Apple-A/UX"},
  {0x40,0x00,0x03,MAC_ANY,MAC_ANY,MAC_ANY,"Net-Ware"},
  {0x47,0x54,0x43,MAC_ANY,MAC_ANY,MAC_ANY,"GTC"},
  {0x48,0x44,0x53,MAC_ANY,MAC_ANY,MAC_ANY,"HDS"},
  {0x80,0x00,0x10,MAC_ANY,MAC_ANY,MAC_ANY,"AT&T"},
  {0x80,0xAD,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"CNET Technology Inc"},
  {0xAA,0x00,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-network-hardware"},
  {0xAA,0x00,0x01,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-network-hardware"},
  {0xAA,0x00,0x02,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-network-hardware"},
  {0xAA,0x00,0x03,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-network-hardware"},
  {0xAA,0x00,0x04,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-network-hardware"},
  {0xAB,0x00,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-Broadcast"},
  {0xAB,0x00,0x01,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-Broadcast"},
  {0xAB,0x00,0x02,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-Broadcast"},
  {0xAB,0x00,0x03,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-Broadcast"},
  {0xAB,0x00,0x04,MAC_ANY,MAC_ANY,MAC_ANY,"DEC-Broadcast"},
  {0xC0,0x00,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"Western-Digital"},
  {0xEC,0x10,0x00,MAC_ANY,MAC_ANY,MAC_ANY,"Enance"},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,"Broadcast"}, 
  {0x01,0x80,0xC2,MAC_ANY,MAC_ANY,MAC_ANY,"LanWan-Spanning-Tree"},
  {0x00,0x40,0xCB,MAC_ANY,MAC_ANY,MAC_ANY,"Lanwan"},
  {0,0,0,0,0,0,NULL},
};

char			*mac_unknown_str = "Unknown";

/* converts-and-catenates an ethernet address to a mac representation.
   Returns 0 if OK. Returns ERR_A_BO on buffer overflows */
t_status		mac_to_str(ea,str,max_len)
t_ether_addr		*ea;
char			*str;
int			max_len;
{
  t_mac			*mac;

  mac = macs;
  while (mac->name)
    {
      if ((ea->o[0] == mac->byte0 || mac->byte0 == MAC_ANY) &&
	  (ea->o[1] == mac->byte1 || mac->byte1 == MAC_ANY) &&
	  (ea->o[2] == mac->byte2 || mac->byte2 == MAC_ANY) &&
	  (ea->o[3] == mac->byte3 || mac->byte3 == MAC_ANY) &&
	  (ea->o[4] == mac->byte4 || mac->byte4 == MAC_ANY) &&
	  (ea->o[5] == mac->byte5 || mac->byte5 == MAC_ANY))
	return (str_cat_str(str,
			    max_len,
			    mac->name));
      mac++;
    }
  return (str_cat_str(str,
		      max_len,
		      mac_unknown_str));
}

/* converts a mac representation to an ethernet address.
   Returns 0 if OK. Returns ERR_A_NOENT if not found */
t_status		mac_from_str(ea,str)
t_ether_addr		*ea;
char			*str;
{
  t_mac			*mac;

  mac = macs;
  while (mac->name)
    {
      if (!strcmp(str,mac->name))
	{
	  if (mac->byte0 != MAC_ANY)
	    ea->o[0] = mac->byte0;
	  if (mac->byte1 != MAC_ANY)
	    ea->o[1] = mac->byte1;
	  if (mac->byte2 != MAC_ANY)
	    ea->o[2] = mac->byte2;
	  if (mac->byte3 != MAC_ANY)
	    ea->o[3] = mac->byte3;
	  if (mac->byte4 != MAC_ANY)
	    ea->o[4] = mac->byte4;
	  if (mac->byte5 != MAC_ANY)
	    ea->o[5] = mac->byte5;
	  return (0);
	}
      mac++;
    }
  return (ERR_PAT_NO_ENT);
}

int	mac_chan;

PAT_NAME_GENERIC(mac_pat_name,
		 (VOID_PTR)&mac_chan,
		 "mac")

PAT_EXTRACT_DECL(mac_pat_extract)
{
  t_ether_addr	ea;

  if (len < sizeof (ea))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&ea,sizeof (ea));
  return (mac_to_str(&ea,
		     str,
		     max_len));
}

PAT_INSERT_DECL(mac_pat_insert)
{
  t_ether_addr	ea;
  t_status	status;	

  if (len < sizeof (ea))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&ea,sizeof (t_ether_addr));
  if ((status = mac_from_str(&ea,
			     value)) != 0)
    return (status);
  FBCOPY(&ea,buf,sizeof (t_ether_addr));
  return (0);
}

PAT_GET_CHOICES_DECL(mac_pat_get_choices)
{
  t_mac		*mac;
  t_status	status;

  mac = macs;
  while (mac->name)
    {
      if (vec_str_index(vec_str,
			mac->name) < 0)
	{
	  if ((status = vec_str_add(vec_str,
				    mac->name)) != 0)
	    return (status);
	}
      mac++;
    }
  return (0);
}

t_pat				mac_pat = 
{
  mac_pat_name,			/* t_pat_name_proc		*/
  NULL,				/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  mac_pat_extract,		/* t_pat_extract_proc		*/
  mac_pat_insert,		/* t_pat_insert_proc		*/
  mac_pat_get_choices,		/* t_pat_get_choices_proc	*/
};
