/*
** pat_ip.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:48:50 1999 
** Last update Thu Oct 28 20:21:17 1999 
*/
#ifndef PAT_IP_H
#define PAT_IP_H	1

#include "pat.h"
#include "pat_inaddr.h"

#define IPOPT_EOOL		0
#define IPOPT_NOP		1
#define IPOPT_RR		7
#define IPOPT_TS		68
#define IPOPT_LSR		131
#define IPOPT_SSR		137

extern t_assoc			ipopt_assocs[];

typedef struct			s_ip
{
  t_u8				vhl;
  t_u8				tos;       
  t_u16				len;       
  t_u16				id;        
  t_u16				fragoff;       
  t_u8				ttl;
  t_u8				p;  
  t_u16				sum;
  t_in_addr			src;
  t_in_addr			dst;
} t_ip;

#define IP_PROTO_IP		0
#define IP_PROTO_ICMP		1
#define IP_PROTO_IGMP		2
#define IP_PROTO_TCP		6
#define IP_PROTO_UDP		17

#define IP_VERSION		4
#define IP_MAXTTL		255

/*
  The current recommended default time to live (TTL) for the
  Internet Protocol (IP) [45,105] is 64.
  */

#define IP_RECOMMENDEDTTL	64

#define IP_MINHLEN		20
#define IP_MAXHLEN		(15 * 4)
#define IP_ALEN			4

#define PAT_IP_CHECK(ippar,bufpar,lenpar) \
	if ((lenpar) < IP_MINHLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(ippar) = (t_ip *)(bufpar);

#define	IPFRAG_DF		2
#define	IPFRAG_MF		1

extern t_assoc			ipfrag_assocs[];
extern t_assoc			iptos_assocs[];

extern int			pat_ip_src_chan;
extern int			pat_ip_dst_chan;

extern t_pat			ipoptdata_pat;
extern t_pat			inaddrtime_pat;
extern t_pat			ipopt_pat;
extern t_pat			ip_pat;

/* PROTO pat_ip.c */
/* pat_ip.c */
t_status pat_ip_init P((void));
void pat_ip_destroy P((void));
t_status inaddrtime_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status inaddrtime_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status inaddrtime_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status inaddrtime_pat_get_fields P((void *data, t_vec *vec_str));
t_status inaddrtime_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status inaddrtime_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status inaddrtime_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status inaddrtime_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status ipoptdata_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status ipoptdata_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_field *ipopt_get_fields P((char *buf, int len, t_status *status));
char *ipopt_get_itmpl P((char *buf, int len, t_status *status));
t_status ipopt_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status ipopt_pat_has_opt P((void *data, char *buf, int len, t_boolean *has_opt_return, t_off *opt_off_return, int *opt_len_return, t_pat **opt_pat_return, void **opt_data_return));
t_status ipopt_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status ipopt_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status ipopt_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status ipopt_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status ipopt_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status ipopt_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_u16 in_cksum P((t_u16 *buf, int nwords));
void ip_compute_sum P((t_ip *ip));
void ip_set_v P((t_ip *ip, int v));
int ip_get_v P((t_ip *ip));
void ip_set_hl P((t_ip *ip, int hl));
int ip_get_hl P((t_ip *ip));
void ip_set_tos P((t_ip *ip, int tos));
int ip_get_tos P((t_ip *ip));
void ip_set_len P((t_ip *ip, int len));
int ip_get_len P((t_ip *ip));
void ip_set_id P((t_ip *ip, int id));
int ip_get_id P((t_ip *ip));
void ip_set_off P((t_ip *ip, int off));
int ip_get_off P((t_ip *ip));
void ip_set_ttl P((t_ip *ip, int ttl));
int ip_get_ttl P((t_ip *ip));
void ip_set_p P((t_ip *ip, int p));
int ip_get_p P((t_ip *ip));
void ip_set_sum P((t_ip *ip, int sum));
int ip_get_sum P((t_ip *ip));
void ip_set_src P((t_ip *ip, t_in_addr *src));
void ip_get_src P((t_ip *ip, t_in_addr *src));
void ip_set_dst P((t_ip *ip, t_in_addr *dst));
void ip_get_dst P((t_ip *ip, t_in_addr *dst));
t_status ip_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status ip_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status ip_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status ip_pat_get_fields P((void *data, t_vec *vec_str));
t_status ip_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status ip_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status ip_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status ip_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status ip_pat_sum P((void *data, char *buf, int len, char *up_buf, int up_len));
t_status ip_pat_adapt_len P((void *data, char *buf, int len));
t_status ip_pat_has_opt P((void *data, char *buf, int len, t_boolean *has_opt_return, t_off *opt_off_return, int *opt_len_return, t_pat **opt_pat_return, void **opt_data_return));
#endif
