/*
** pat_igmp.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:49:03 1999 
** Last update Thu Oct 28 20:21:20 1999 
*/
#ifndef PAT_IGMP_H
#define PAT_IGMP_H	1

#include "pat.h"
#include "pat_inaddr.h"
#include "pat_ip.h"

typedef struct		s_igmptrquery
{
  t_in_addr		src;
  t_in_addr		dst;
  t_in_addr		resp;
  t_u32			ttlid;
} t_igmptrquery;

typedef struct		s_igmptrresp
{
  t_u32			qarr;
  t_in_addr		in;
  t_in_addr		out;
  t_in_addr		rmt;
  t_u32			vifin;
  t_u32			vifout;
  t_u32			pktcnt;
  t_u8			rproto;
  t_u8			fttl;
  t_u8			smask;
  t_u8			rflags;
} t_igmptrresp;

typedef struct		s_igmp
{
  t_u8			vtype;
  t_u8			unused;
  t_u16			cksum;
  t_in_addr		group;
} t_igmp;

#define IGMP_HLEN	8

#define PAT_IGMP_CHECK(igmppar,bufpar,lenpar) \
	if ((lenpar) < IGMP_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(igmppar) = (t_igmp *)(bufpar);

extern t_pat		igmp_pat;

/* PROTO pat_igmp.c */
/* pat_igmp.c */
void igmp_compute_sum P((t_ip *ip, t_igmp *igmp));
t_status igmp_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status igmp_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status igmp_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status igmp_pat_get_fields P((void *data, t_vec *vec_str));
t_status igmp_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status igmp_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status igmp_pat_sum P((void *data, char *buf, int len, char *up_buf, int up_len));
t_status igmp_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status igmp_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
