/*
** pat_ether.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:49:30 1999 
** Last update Thu Oct 28 20:21:26 1999 
*/
#ifndef PAT_ETHER_H
#define PAT_ETHER_H	1

#include "pat.h"
#include "pat_ethaddr.h"

typedef struct			s_ether
{
  t_u8				dhost[6];
  t_u8				shost[6];
  t_u16				type;
} t_ether;

#define ETHER_HLEN		14

#define PAT_ETHER_CHECK(etherpar,bufpar,lenpar) \
	if ((lenpar) < ETHER_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(etherpar) = (t_ether *)(bufpar);

#ifndef ETHERTYPE_IP
# define ETHERTYPE_IP		0x800
#endif
#ifndef ETHERTYPE_ARP
# define ETHERTYPE_ARP		0x806
#endif
#ifndef ETHERTYPE_RARP
# define ETHERTYPE_RARP		0x8035
#endif
#ifndef ETHERTYPE_ATALK
# define ETHERTYPE_ATALK	0x809b
#endif

extern t_assoc			ethertype_assocs[];

extern t_pat			ether_pat;

/* PROTO pat_ether.c */
/* pat_ether.c */
void ether_set_shost P((t_ether *ether, t_ether_addr *ea));
void ether_get_shost P((t_ether *ether, t_ether_addr *ea));
void ether_set_dhost P((t_ether *ether, t_ether_addr *ea));
void ether_get_dhost P((t_ether *ether, t_ether_addr *ea));
void ether_set_type P((t_ether *ether, int type));
int ether_get_type P((t_ether *ether));
t_status ether_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status ether_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status ether_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status ether_pat_get_fields P((void *data, t_vec *vec_str));
t_status ether_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status ether_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status ether_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status ether_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
