/*
** pat_ethaddr.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:43:42 1999 
** Last update Thu Oct 28 20:20:06 1999 
*/
#include "pat.h"
#include "pat_ether.h"
#include "pat_ethaddr.h"
#include "pat_mac.h"

t_boolean			pat_etheraddr_dec_way = FALSE;

t_status			etheraddr_from_str(ea,str)
t_ether_addr			*ea;
char				*str;
{
  int				nmatch;
  unsigned int			o[6];
  int				i;
  unsigned int			pat;
  t_boolean			badpat;

  nmatch = 0;
  if (index(str,'-'))
    nmatch = sscanf(str,"%x-%x-%x-%x-%x-%x",
		    &(o[0]),&(o[1]),&(o[2]),&(o[3]),&(o[4]),&(o[5]));
  else
    if (index(str,':'))
      nmatch = sscanf(str,"%x:%x:%x:%x:%x:%x",
		      &(o[0]),&(o[1]),&(o[2]),&(o[3]),&(o[4]),&(o[5]));
  if (nmatch != sizeof (t_ether_addr))
    return (ERR_PAT_BAD_FMT);
  badpat = TRUE;
  pat = o[0];
  i = 0;
  while (i < sizeof (t_ether_addr))
    {
      if (o[i] != pat)
	badpat = FALSE;
      ea->o[i] = o[i];
      i++;
    }
  if (badpat && pat != 0xff && pat != 0x00)
    return (ERR_PAT_BAD_ADDR);
  return (0);
}

t_status			etheraddr_to_str(ea,str,max_len)
t_ether_addr			*ea;
char				*str;
int				max_len;
{
  unsigned char			o[6];
  int				i;
  t_status			status;
  int				c;

  i = 0;
  while (i < sizeof (t_ether_addr))
    {
      o[i] = ea->o[i];
      i++;
    }
  if (pat_etheraddr_dec_way)
    c = '-';
  else
    c = ':';
  return (str_cat_fmt_va(str,max_len,
			 "%02x%c%02x%c%02x%c%02x%c%02x%c%02x",
			 (unsigned char)o[0],
			 c,
			 (unsigned char)o[1],
			 c,
			 (unsigned char)o[2],
			 c,
			 (unsigned char)o[3],
			 c,
			 (unsigned char)o[4],
			 c,
			 (unsigned char)o[5]));
}

char			*typ_etheraddr_ntoa(ea)
t_ether_addr		*ea;
{
  static char		buf[STR_BUFSIZ]; /* ITS ENOUGH */
  t_status		status;	
  
  buf[0] = 0;
  status = etheraddr_to_str(ea,buf,sizeof (buf));
  assert(status == 0);
  return (buf);
}

char			*etheraddr_itmpl = "\n\
<table _name=etheraddr[%i%] bgcolor=\"%%etheraddrColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"set(etheraddr[%i%].Etheraddr)\">%%etheraddr[%i%].Etheraddr%%</a>(<a href=\"set(etheraddr[%i%].etheraddr)\">%%etheraddr[%i%].etheraddr%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

t_field			etheraddr_fields[] = 
{
  {"etheraddr",    0,      &etheraddr_pat,                 NULL},
  {"Etheraddr",    0,      &mac_pat,                       NULL},
  NULL_FIELD
};

int			etheraddr_chan;

PAT_NAME_GENERIC(etheraddr_pat_name,
		 (VOID_PTR)&etheraddr_chan,
		 "etheraddr")

PAT_GET_FIELD_GENERIC(etheraddr_pat_get_field,
		      etheraddr_fields)

PAT_SET_FIELD_GENERIC(etheraddr_pat_set_field,
		      etheraddr_fields)

PAT_GET_FIELDS_GENERIC(etheraddr_pat_get_fields,
		       etheraddr_fields)

PAT_GET_TMPL_GENERIC(etheraddr_pat_get_tmpl,
		     (VOID_PTR)&etheraddr_chan,
		     etheraddr_itmpl)

PAT_GET_FIELD_PAT_GENERIC(etheraddr_pat_get_field_pat,
			  etheraddr_fields)

PAT_OFF_GENERIC(etheraddr_pat_off,
		6)

PAT_SUB_GENERIC(etheraddr_pat_sub,
		&etheraddr_pat)

PAT_EXTRACT_DECL(etheraddr_pat_extract)
{
  t_ether_addr	etheraddr;
  
  if (len < sizeof (etheraddr))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&etheraddr,sizeof (etheraddr));
  return (etheraddr_to_str(&etheraddr,
			   str,
			   max_len));
}

PAT_INSERT_DECL(etheraddr_pat_insert)
{
  t_ether_addr	etheraddr;
  t_status	status;	

  if (len < sizeof (etheraddr))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = etheraddr_from_str(&etheraddr,
				   value)) != 0)
    return (status);
  FBCOPY(&etheraddr,buf,sizeof (t_ether_addr));
  return (0);
}

t_pat				etheraddr_pat = 
{
  etheraddr_pat_name,		/* t_pat_name_proc		*/
  etheraddr_pat_off,		/* t_pat_off_proc		*/
  etheraddr_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  etheraddr_pat_get_field,	/* t_pat_get_field_proc		*/
  etheraddr_pat_set_field,	/* t_pat_set_field_proc		*/
  etheraddr_pat_get_fields,	/* t_pat_get_fields_proc	*/
  etheraddr_pat_get_tmpl,	/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  etheraddr_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  etheraddr_pat_extract,	/* t_pat_extract_proc		*/
  etheraddr_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
