/*
** pat_bytebuf.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:44:04 1999 
** Last update Thu Oct 28 20:20:10 1999 
*/
#include "pat.h"
#include "pat_bytebuf.h"
#include "pat_8.h"
#include "pat_data.h"

char			*bytebuf_itmpl = "\n\
<table _name=bytebuf[%i%] bgcolor=\"%%bytebufColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<small>\n\
<a href=\"set(bytebuf[%i%].len)\">%%bytebuf[%i%].len%%</a> byte(s)\n\
</td>\n\
<td align=center>\n\
<a href=\"set(bytebuf[%i%].buf)\">%%bytebuf[%i%].buf%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

t_field			bytebuf_fields[] = 
{
  {"len",        0,      &u8_pat,		NULL},
  {"buf",        0,      &bytebuf_pat,		NULL},
  {"Buf",        0,      &bytebuf_string_pat,	NULL},
  NULL_FIELD
};

int	bytebuf_chan;

PAT_NAME_GENERIC(bytebuf_pat_name,
		 (VOID_PTR)&bytebuf_chan,
		 "bytebuf")

PAT_GET_FIELD_GENERIC(bytebuf_pat_get_field,
		      bytebuf_fields)

PAT_SET_FIELD_GENERIC(bytebuf_pat_set_field,
		      bytebuf_fields)

PAT_GET_FIELDS_GENERIC(bytebuf_pat_get_fields,
		       bytebuf_fields)

PAT_GET_TMPL_GENERIC(bytebuf_pat_get_tmpl,
		     (VOID_PTR)&bytebuf_chan,
		     bytebuf_itmpl)

PAT_GET_FIELD_PAT_GENERIC(bytebuf_pat_get_field_pat,
			  bytebuf_fields)

PAT_SUB_GENERIC(bytebuf_pat_sub,
		&bytebuf_pat)

PAT_EXTRACT_DECL(bytebuf_pat_extract)
{
  t_u8		my_len;
  
  if (len < 1)
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&my_len,sizeof (my_len));
  if (len < (1 + my_len))
    return (ERR_PAT_TRUNC_FIELD);
  return (buf_to_xdata_str(buf + 1,
			   my_len,
			   pat_data_bytes_per_line,
			   "\n",
			   " ",
			   str,
			   max_len));
}

PAT_INSERT_DECL(bytebuf_pat_insert)
{
  t_status	status;	
  int		ilen;
  char		my_buf[BUFSIZ];
  t_u8		my_len;
  
  if ((status = xdata_to_buf(value,
			     my_buf,
			     &ilen,
			     sizeof (my_buf))) != 0)
    return (status);
  if (ilen > 255)
    return (ERR_PAT_TOO_BIG);
  if (len < (ilen + 1))
    return (ERR_PAT_TRUNC_FIELD);
  my_len = ilen;
  FBCOPY(&my_len,buf,sizeof (my_len));
  bcopy(my_buf,buf + 1,ilen);
  return (0);
}

PAT_OFF_DECL(bytebuf_pat_off)
{
  int		my_len;
  
  if (len < 1)
    return (ERR_PAT_TRUNC_PAT);
  my_len = (t_u32)(t_u8)(buf[0]);
  (*off_return) = (t_off)my_len + 1;
  return (0);
}

t_pat				bytebuf_pat = 
{
  bytebuf_pat_name,		/* t_pat_name_proc		*/
  bytebuf_pat_off,		/* t_pat_off_proc		*/
  bytebuf_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  bytebuf_pat_get_field,	/* t_pat_get_field_proc		*/
  bytebuf_pat_set_field,	/* t_pat_set_field_proc		*/
  bytebuf_pat_get_fields,	/* t_pat_get_fields_proc	*/
  bytebuf_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  bytebuf_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  bytebuf_pat_extract,		/* t_pat_extract_proc		*/
  bytebuf_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

char			*bytebuf_string_itmpl = "\n\
<table _name=bytebuf_string[%i%] bgcolor=\"%%bytebufColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<small>\n\
<a href=\"set(bytebuf_string[%i%].len)\">%%bytebuf_string[%i%].len%%</a> byte(s)\n\
</td>\n\
<td align=center>\n\
<a href=\"set(bytebuf_string[%i%].Buf)\">%%bytebuf_string[%i%].Buf%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	bytebuf_string_chan;

PAT_NAME_GENERIC(bytebuf_string_pat_name,
		 (VOID_PTR)&bytebuf_string_chan,
		 "bytebuf_string")

PAT_GET_TMPL_GENERIC(bytebuf_string_pat_get_tmpl,
		     (VOID_PTR)&bytebuf_string_chan,
		     bytebuf_string_itmpl)

PAT_SUB_GENERIC(bytebuf_string_pat_sub,
		&bytebuf_string_pat)

PAT_EXTRACT_DECL(bytebuf_string_pat_extract)
{
  int		my_len;
  
  if (len < 1)
    return (ERR_PAT_TRUNC_FIELD);
  my_len = (t_u32)(t_u8)(buf[0]);
  if (len < (1 + my_len))
    return (ERR_PAT_TRUNC_FIELD);
  return (str_cat_buf(str,
		      max_len,
		      buf + 1,
		      my_len));
}

PAT_INSERT_DECL(bytebuf_string_pat_insert)
{
  t_status	status;	
  int		my_len;
  
  if ((my_len = strlen(value)) > 255)
    return (ERR_PAT_TOO_BIG);
  if (len < (my_len + 1))
    return (ERR_PAT_TRUNC_FIELD);
  buf[0] = (t_u8)my_len;
  bcopy(value,buf + 1,my_len);
  return (0);
}

t_pat				bytebuf_string_pat = 
{
  bytebuf_string_pat_name,	/* t_pat_name_proc		*/
  bytebuf_pat_off,		/* t_pat_off_proc		*/
  bytebuf_string_pat_sub,	/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  bytebuf_pat_get_field,	/* t_pat_get_field_proc		*/
  bytebuf_pat_set_field,	/* t_pat_set_field_proc		*/
  bytebuf_pat_get_fields,	/* t_pat_get_fields_proc	*/
  bytebuf_string_pat_get_tmpl,	/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  bytebuf_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  bytebuf_string_pat_extract,	/* t_pat_extract_proc		*/
  bytebuf_string_pat_insert,	/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
