/*
** pat_buf.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:44:11 1999 
** Last update Thu Oct 28 20:20:12 1999 
*/
#include "pat.h"
#include "pat_data.h"
#include "pat_buf.h"

int	buf_chan;

PAT_NAME_GENERIC(buf_pat_name,
		 (VOID_PTR)&buf_chan,
		 "buf")

PAT_EXTRACT_DECL(buf_pat_extract)
{
  int		ulen;
  
  if ((ulen = (int)(data)) == 0)
    return (ERR_PAT_NULL_DATA);
  if (len < ulen)
    return (ERR_PAT_TRUNC_FIELD);
  return (buf_to_xdata_str(buf,
			   ulen,
			   pat_data_bytes_per_line,
			   "\n",
			   " ",
			   str,
			   max_len));
}

PAT_INSERT_DECL(buf_pat_insert)
{
  t_status	status;	
  int		ilen;
  char		my_buf[BUFSIZ];
  int		ulen;
  
  if ((ulen = (int)(data)) == 0)
    return (ERR_PAT_NULL_DATA);
  if (len < ulen)
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = xdata_to_buf(value,
			     my_buf,
			     &ilen,
			     sizeof (my_buf))) != 0)
    return (status);
  if (ulen != ilen)
    return (ERR_PAT_BAD_LEN);
  bcopy(my_buf,buf,ulen);
  return (0);
}

PAT_OFF_DECL(buf_pat_off)
{
  (*off_return) = (t_off)(data);
  return (0);
}	

t_pat				buf_pat = 
{
  buf_pat_name,			/* t_pat_name_proc		*/
  buf_pat_off,			/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  buf_pat_extract,		/* t_pat_extract_proc		*/
  buf_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	bufassoc_chan;

PAT_NAME_GENERIC(bufassoc_pat_name,
		 (VOID_PTR)&bufassoc_chan,
		 "bufassoc")

PAT_EXTRACT_DECL(bufassoc_pat_extract)
{
  t_buf_assocs_data	*bad;
  t_assoc		*assoc;

  if ((bad = (t_buf_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < bad->ulen)
    return (ERR_PAT_TRUNC_FIELD);
  assoc = bad->assocs;
  while (assoc->left)
    {
      if (!bcmp(assoc->right,buf,bad->ulen))
	return (str_cat_str(str,
			    max_len,
			    assoc->left));
      assoc++;
    }
  return (buf_to_xdata_str(buf,
			   bad->ulen,
			   pat_data_bytes_per_line,
			   "\n",
			   " ",
			   str,
			   max_len));
}

PAT_INSERT_DECL(bufassoc_pat_insert)
{
  t_status		status;	
  int			ilen;
  char			my_buf[BUFSIZ];
  t_buf_assocs_data	*bad;
  t_assoc		*assoc;

  if ((bad = (t_buf_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < bad->ulen)
    return (ERR_PAT_TRUNC_FIELD);
  assoc = bad->assocs;
  while (assoc->left)
    {
      if (!strcmp(assoc->left,value))
	{
	  bcopy(assoc->right,buf,bad->ulen);
	  return (0);
	}
      assoc++;
    }
  if ((status = xdata_to_buf(value,
			     my_buf,
			     &ilen,
			     sizeof (my_buf))) != 0)
    return (status);
  if (bad->ulen != ilen)
    return (ERR_PAT_BAD_LEN);
  bcopy(my_buf,buf,bad->ulen);
  return (0);
}

PAT_OFF_DECL(bufassoc_pat_off)
{
  t_buf_assocs_data	*bad;

  if ((bad = (t_buf_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  (*off_return) = (t_off)(bad->ulen);
  return (0);
}	

PAT_GET_CHOICES_DECL(bufassoc_pat_get_choices)
{
  t_buf_assocs_data	*bad;
  t_assoc		*assoc;
  t_status		status;

  if ((bad = (t_buf_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  assoc = bad->assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				bufassoc_pat = 
{
  bufassoc_pat_name,		/* t_pat_name_proc		*/
  bufassoc_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  bufassoc_pat_extract,		/* t_pat_extract_proc		*/
  bufassoc_pat_insert,		/* t_pat_insert_proc		*/
  bufassoc_pat_get_choices,	/* t_pat_get_choices_proc	*/
};

int	bufuntil_chan;

PAT_NAME_GENERIC(bufuntil_pat_name,
		 (VOID_PTR)&bufuntil_chan,
		 "bufuntil")

PAT_EXTRACT_DECL(bufuntil_pat_extract)
{
  return (buf_to_xdata_str(buf,
			   len,
			   pat_data_bytes_per_line,
			   "\n",
			   " ",
			   str,
			   max_len));
}

PAT_INSERT_DECL(bufuntil_pat_insert)
{
  t_status	status;	
  int		ilen;
  char		my_buf[BUFSIZ];
    
  if ((status = xdata_to_buf(value,
			     my_buf,
			     &ilen,
			     sizeof (my_buf))) != 0)
    return (status);
  if (len < ilen)
    return (ERR_PAT_TRUNC_FIELD);
  bcopy(my_buf,buf,ilen);
  return (0);
}

PAT_OFF_DECL(bufuntil_pat_off)
{
  (*off_return) = len;
  return (0);
}	

t_pat				bufuntil_pat = 
{
  bufuntil_pat_name,		/* t_pat_name_proc		*/
  bufuntil_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  bufuntil_pat_extract,		/* t_pat_extract_proc		*/
  bufuntil_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

char			*bufstruntil_itmpl = "\n\
<table _name=bufstruntil[%i%] bgcolor=\"%%bufstruntilColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<a href=\"set(bufstruntil[%i%].str)\">%%bufstruntil[%i%].str%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

t_field			bufstruntil_fields[] = 
{
  {"buf",        0,      &bufuntil_pat,			NULL},
  {"str",        0,      &bufstruntil_pat,		NULL},
  NULL_FIELD
};

int	bufstruntil_chan;

PAT_NAME_GENERIC(bufstruntil_pat_name,
		 (VOID_PTR)&bufstruntil_chan,
		 "bufstruntil")

PAT_EXTRACT_DECL(bufstruntil_pat_extract)
{
  return (buf_to_str(buf,
		     len,
		     str,
		     max_len));
}

PAT_INSERT_DECL(bufstruntil_pat_insert)
{
  t_status	status;	
  int		ilen;
  char		my_buf[BUFSIZ];
    
  if ((status = str_to_buf(value,
			   my_buf,
			   &ilen,
			   sizeof (my_buf))) != 0)
    return (status);
  if (len < ilen)
    return (ERR_PAT_TRUNC_FIELD);
  bcopy(my_buf,buf,ilen);
  return (0);
}

PAT_OFF_DECL(bufstruntil_pat_off)
{
  (*off_return) = len;
  return (0);
}	

PAT_GET_FIELD_GENERIC(bufstruntil_pat_get_field,
		      bufstruntil_fields)

PAT_SET_FIELD_GENERIC(bufstruntil_pat_set_field,
		      bufstruntil_fields)

PAT_GET_FIELDS_GENERIC(bufstruntil_pat_get_fields,
		       bufstruntil_fields)

PAT_GET_TMPL_GENERIC(bufstruntil_pat_get_tmpl,
		     (VOID_PTR)&bufstruntil_chan,
		     bufstruntil_itmpl)

PAT_GET_FIELD_PAT_GENERIC(bufstruntil_pat_get_field_pat,
			  bufstruntil_fields)

t_pat				bufstruntil_pat = 
{
  bufstruntil_pat_name,		/* t_pat_name_proc		*/
  bufstruntil_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  bufstruntil_pat_get_field,	/* t_pat_get_field_proc		*/
  bufstruntil_pat_set_field,	/* t_pat_set_field_proc		*/
  bufstruntil_pat_get_fields,	/* t_pat_get_fields_proc	*/
  bufstruntil_pat_get_tmpl,	/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  bufstruntil_pat_get_field_pat,/* t_pat_get_field_pat_proc	*/
  bufstruntil_pat_extract,	/* t_pat_extract_proc		*/
  bufstruntil_pat_insert,	/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
