/*
** pat_boolean.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:44:25 1999 
** Last update Thu Oct 28 20:20:15 1999 
*/
#include "pat.h"
#include "pat_boolean.h"

int	boolean_chan;

PAT_NAME_GENERIC(boolean_pat_name,
		 (VOID_PTR)&boolean_chan,
		 "boolean")

PAT_OFF_GENERIC(boolean_pat_off,
		sizeof (t_boolean))

PAT_EXTRACT_DECL(boolean_pat_extract)
{
  t_boolean	boolean;
  
  if (len < sizeof (boolean))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&boolean,sizeof (t_boolean));
  if (boolean)
    return (str_cat_str(str,
			max_len,
			TRUE_STR));
  else
    return (str_cat_str(str,
			max_len,
			FALSE_STR));
}

PAT_INSERT_DECL(boolean_pat_insert)
{
  t_boolean	boolean;
  t_status	status;	
  
  if (len < sizeof (boolean))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = atobooleanstrict(value,
				 &boolean)) != 0)
    return (status);
  FBCOPY(&boolean,buf,sizeof (t_boolean));
  return (0);
}

PAT_GET_CHOICES_DECL(boolean_pat_get_choices)
{
  t_status	status;

  if ((status = vec_str_add(vec_str,
			    TRUE_STR)) != 0)
    return (status);
  if ((status = vec_str_add(vec_str,
			    FALSE_STR)) != 0)
    return (status);
  return (0);
}
    
t_pat				boolean_pat = 
{
  boolean_pat_name,		/* t_pat_name_proc		*/
  boolean_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  boolean_pat_extract,		/* t_pat_extract_proc		*/
  boolean_pat_insert,		/* t_pat_insert_proc		*/
  boolean_pat_get_choices,	/* t_pat_get_choices_proc	*/
};
