/*
** pat_arp.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:50:32 1999 
** Last update Thu Oct 28 20:21:37 1999 
*/
#ifndef PAT_ARP_H
#define PAT_ARP_H	1

#include "pat_ethaddr.h"
#include "pat_inaddr.h"

typedef struct			s_arpethip
{
  t_u8				sha[6];
  t_u8				spa[4];
  t_u8				tha[6];
  t_u8				tpa[4];
} t_arpethip;

#define ARPETHIP_HLEN		20

#define PAT_ARPETHIP_CHECK(aeipar,bufpar,lenpar) \
    if ((lenpar) < ARPETHIP_HLEN)\
	return (ERR_PAT_TRUNC_PAT);\
    (aeipar) = (t_arpethip *)(bufpar);

typedef struct			s_arp
{
  t_u16				hrd;
  t_u16				pro;
  t_u8				hln;
  t_u8				pln;
  t_u16				op;
} t_arp;

#define ARP_HLEN		8

#define PAT_ARP_CHECK(arppar,bufpar,lenpar) \
	if ((lenpar) < ARP_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(arppar) = (t_arp *)(bufpar);

#define ARPHRD_ETHER		1	/* ethernet hardware address */
#define ARPHRD_802		6	/* 802 net hardware address */

extern t_assoc			arphrd_assocs[];

#define	ARPOP_REQUEST		1	/* request to resolve address */
#define	ARPOP_REPLY		2	/* response to previous request */

extern t_assoc			arpop_assocs[];

extern t_pat			arpethip_pat;
extern t_pat			arp_pat;

/* PROTO pat_arp.c */
/* pat_arp.c */
t_status arpethip_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status arpethip_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status arpethip_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status arpethip_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status arpethip_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status arpethip_pat_get_fields P((void *data, t_vec *vec_str));
t_status arpethip_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status arpethip_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
void arp_set_hrd P((t_arp *arp, int hrd));
int arp_get_hrd P((t_arp *arp));
void arp_set_pro P((t_arp *arp, int pro));
int arp_get_pro P((t_arp *arp));
void arp_set_hln P((t_arp *arp, int hln));
int arp_get_hln P((t_arp *arp));
void arp_set_pln P((t_arp *arp, int pln));
int arp_get_pln P((t_arp *arp));
void arp_set_op P((t_arp *arp, int op));
int arp_get_op P((t_arp *arp));
t_status arp_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status arp_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status arp_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status arp_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status arp_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status arp_pat_get_fields P((void *data, t_vec *vec_str));
t_status arp_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status arp_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
#endif
