/*
** pat.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:45:07 1999 
** Last update Thu Oct 28 20:20:22 1999 
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "pat.h"
#include "nbgethost.h"
#include "pat_data.h"
#include "pat_ip.h"
#include "pat_udp.h"
#include "pat_pat.h"	

t_boolean			pat_resolve = TRUE;
t_32				pat_base = 10;
t_32				pat_verb_level = 0;
t_32				pat_zone = 0;

t_status			pat_init(VOID_DECL)
{
  t_status			status;

  pat_zone = gmt2local(0);
  if ((status = nbgethost_init()) != 0)
    {
      err_print(status,"nbgethost_init");
      return (status);
    }
  if ((status = pat_data_init()) != 0)
    {
      err_print(status,"pat_data_init");
      return (status);
    }
  if ((status = pat_ip_init()) != 0)
    {
      err_print(status,"pat_ip_init");
      return (status);
    }
  if ((status = pat_udp_init()) != 0)
    {
      err_print(status,"pat_udp_init");
      return (status);
    }
  if ((status = pat_dict_init()) != 0)
    {
      err_print(status,"pat_dict_init");
      return (status);
    }
  return (0);
}

VOID_FUNC			pat_destroy(VOID_DECL)
{
  pat_dict_destroy();
  pat_udp_destroy();
  pat_ip_destroy();
  pat_data_destroy();
  nbgethost_destroy();
}

t_mask_def			pat_verb_level_mask_defs[] = 
{
  {"nbstuff",			VERB_PAT_NBSTUFF},
  {"pkt",			VERB_PAT_PKT},
  {"pktsav",			VERB_PAT_PKTSAV},
  {"pktio",			VERB_PAT_PKTIO},
  {"pktsub",			VERB_PAT_PKTSUB},
  {"pktwalk",			VERB_PAT_PKTWALK},
  {"all",			~0L},
  {NULL,			0}
};

#ifdef DEBUG
/* initializes the pat debug env. 
   This is a debug function */
VOID_FUNC		pat_debug_init(VOID_DECL)
{
  char			*str;
  t_mask		mask;

  if (str = getenv("PAT_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = PAT_VEC_NEW(&status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) != 0)
	{
	  err_print(status,"pat_debug_init");
	  abort();
	}
      if ((status = mask_from_vec_str(pat_verb_level_mask_defs,
				      vec,
				      &mask)) != 0)
	{
	  err_print(status,"pat_debug_init");
	  abort();
	}
      pat_verb_level = (t_32)mask;
      vec_str_delete(vec);
    }
}
#endif
