/*
** mg_vec_int.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 16:26:20 1999 vianney rancurel
** Last update Thu Oct 28 20:15:27 1999 
*/
#include "mg.h"

/* returns the average value of a vector of integer, -1 if vec is empty */
int		vec_int_average(vec)
t_vec		*vec;
{
  int		average;

  if (!VEC_COUNT(vec))
    return (-1);
  average = 0;
  VEC_FOR(vec,VOID_PTR p)
    {
      average += (int)p;
    }
  VEC_ENDFOR;
  return (average / VEC_COUNT(vec));
}

#ifdef DEBUG
/* prints out a vector of integer.
   This is a debug function */
VOID_FUNC	vec_int_print(vec)
t_vec		*vec;
{
  VEC_FOR(vec,VOID_PTR p)
    {
      fprintf(stderr,"%d ",p);      
    }
  VEC_ENDFOR;
  fprintf(stderr,"\n");
}
#endif
