/*
** mg_stack.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:13:51 1999 vianney rancurel
** Last update Thu Oct 28 20:15:40 1999 
*/
#include "mg.h"

/* pushes an elt in a stack.
   Note that it could be a macro because it simply calls vec_add(3).
   Returns what vec_add(3) returns */
t_status	stack_push(stack,elt)
t_vec		*stack;
VOID_PTR	elt;
{
  return (vec_add(stack,elt));
}

/* lookups an elt in the stack.
   Returns 0 if OK (and fills *elt), return ERR_MG_NOENT if stack is empty */
t_status	stack_lookup(stack,elt)
t_vec		*stack;
VOID_PTR	*elt;		/* Pointer to an opaque elt */
{
  if (VEC_COUNT(stack) == 0)
    return (ERR_MG_NOENT);
  else
    {
      (*elt) = VEC_LAST_ELT(stack);
      return (0);
    }
}

/* pops an elt in the stack.
   Returns the same values as stack_lookup(3) */
t_status	stack_pop(stack,elt)
t_vec		*stack;
VOID_PTR	*elt;		/* Pointer to an opaque elt */
{
  t_status	status;

  if ((status = stack_lookup(stack,elt)) == 0)
    {
      VEC_RM_LAST_ELT(stack);
      return (0);
    }
  return (status);
}
