/*
** mg_misc.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:14:30 1999 vianney rancurel
** Last update Tue Nov  2 03:25:23 1999 
*/
#include <ctype.h>
#include "mg.h"

/* converts a string to a boolean value.
   Returns TRUE if str matches "true" (case insensitive), FALSE otherwise. */
t_boolean		atobooleanfalse(str)
char			*str;
{
  if (!strcasecmp(str,"true"))
    return (TRUE);
  return (FALSE);
}

/* converts a string to a boolean value.
   Returns FALSE if str matches "false" (case insensitive), TRUE otherwise. */
t_boolean		atobooleantrue(str)
char			*str;
{
  if (!strcasecmp(str,"false"))
    return (FALSE);
  return (TRUE);
}

t_status		atobooleanstrict(str,val)
char			*str;
t_boolean		*val;
{
  if (!strcasecmp(str,"true"))
    {
      (*val) = TRUE;
      return (0);
    }
  if (!strcasecmp(str,"false"))
    {
      (*val) = FALSE;
      return (0);
    }
  return (ERR_MG_BOOLEAN_SYNTAX);
}

/* allocates memory in a pool (a vector of pointers).
   Pool must pre-exist.
   Return a pointer to a memory zone or NULL */
VOID_PTR		pool_alloc(pool,
				   alloc_proc,
				   size,
				   comment,
				   free_proc,
				   status)
t_vec			*pool;			/* The pool */
t_alloc_proc		alloc_proc;		/* Alloc. method */
size_t			size;			/* Size requested */
char			*comment;		/* Major comment */
t_free_proc		free_proc;		/* Free method */
t_status		*status;		/* Filled if NULL */
{
  VOID_PTR		ptr;

  if ((ptr = alloc_proc(size,
			comment,
			"pool_alloc:ptr",
			status)) == NULL)
    return (NULL);
  if (((*status) = vec_add(pool,ptr)) != 0)
    {
      free_proc(ptr,
		comment,
		"pool_alloc:ptr");
      return (NULL);
    }
}

/* duplicates a string.
   Returns a new string or NULL if failed. */
char			*strdup_alloc(str,alloc_proc,comment1,comment2,status)
char			*str;		/* The reference string */	
t_alloc_proc		alloc_proc;	/* The alloc method */
char			*comment1;	/* The major comment */
char			*comment2;	/* The minor comment */
t_status		*status;	/* Filled if NULL */	
{
  char			*nstr;
  int			len;

  len = strlen(str);
  if ((nstr = alloc_proc((len + 1) * sizeof (char),
			 comment1,
			 comment2,
			 status)) == NULL)
    return (NULL);
  strcpy(nstr,str);
  return (nstr);
}

/* skips bytes matching chars. */
char			*str_skip(str,chars)
char			*str;
char			*chars;
{
  while (*str)
    {
      if (!index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

/* finds first byte in str matching chars */
char			*str_find(str,chars)
char			*str;
char			*chars;
{
  while (*str)
    {
      if (index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

/* buffer version of index(3). */
char			*bindex(buf,len,c)
char			*buf;
int			len;
int			c;
{
  int			i;

  i = 0;
  while (i < len)
    {
      if (buf[i] == c)
	return (buf + i);
      i++;
    }
  return (NULL);
}

/* counts the occurences of c in str */
int			indexcount(str,c)
char			*str;
int			c;
{
  int			count;

  count = 0;
  while (*str)
    {
      if ((*str) == c)
	count++;
      str++;
    }
  return (count);
}

/* destructive-lowercase of str */
VOID_FUNC		str_lower(str)
char			*str;
{
  while (*str)
    {
      if (isupper(*str))
	*str = tolower(*str);
      str++;
    }
}

#ifdef DEBUG
/* initializes debug features of mg_* part.
   This is a debug function. */
VOID_FUNC		a_debug_init(VOID_DECL)
{
  /* NOP FOR THE MOMENT */
}

/* fills a buffer with 0xff.
   This is a debug function */
VOID_FUNC		bff(buf,len)
char			*buf;
int			len;
{
  int			i;

  i = 0;
  while (i < len)
    {
      buf[i] = 0xff;
      i++;
    }
}
#endif
