/*
** mg_dm.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:06:49 1999 vianney rancurel
** Last update Thu Oct 28 20:17:58 1999 
*/
#ifndef MG_DM_H
#define MG_DM_H	1

#include "mg.h"

typedef struct	s_dm
{
  t_id		*id;	/* MUST BE SET	*/
  size_t	cumulated;
  size_t	in_use;
  t_boolean	verbose;
  t_boolean	go_on;
  char		*regexp;
} t_dm;

typedef struct	s_dm_elt
{
  VOID_PTR	ptr;
  size_t	size;
  char		*comment1;
  char		*comment2;
  t_boolean	available;
} t_dm_elt;

/* PROTO mg_dm.c */
/* mg_dm.c */
void dm_init P((t_dm *dm));
t_dm_elt *dm_register_ptr P((t_dm *dm, void *ptr, size_t size, char *comment1, char *comment2));
t_dm_elt *dm_unregister_ptr P((t_dm *dm, void *ptr, char *comment1, char *comment2));
void *dm_malloc P((t_dm *dm, size_t size, char *comment1, char *comment2, t_status *status));
void *dm_realloc P((t_dm *dm, void *old_ptr, size_t size, char *comment1, char *comment2, t_status *status));
void dm_free P((t_dm *dm, void *ptr, char *comment1, char *comment2));
void dm_unmark P((t_dm *dm, void *ptr, char *comment1, char *comment2));
t_status dm_show_walk P((t_hash_elt *he, t_dm *dm));
void dm_show P((t_dm *dm));
t_status dm_destroy_walk P((t_hash_elt *he, t_dm *dm));
void dm_destroy P((t_dm *dm));
#endif
