/*
** mg_dict_str.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:06:59 1999 vianney rancurel
** Last update Thu Oct 28 20:18:01 1999 
*/
#ifndef DICT_STR_H
#define DICT_STR_H	1

#include "mg.h"

typedef struct		s_dict_str_data
{
  t_dict		*dict;
  char			*str;
} t_dict_str_data;

typedef struct		s_vec_str_data
{
  t_vec			*vec;
  char			*str;
} t_vec_str_data;

typedef	t_status	(*t_dict_str_add_proc) P((t_dict *dict,
						  char *name,
						  char *value));

/* PROTO mg_dict_str.c */
/* mg_dict_str.c */
t_status dict_str_override P((t_dict *dict, char *key, char *value));
t_status dict_str_override_with_len P((t_dict *dict, char *key, char *str, int len));
t_status dict_str_add P((t_dict *dict, char *key, char *value));
t_status dict_str_rm P((t_dict *dict, char *key));
void dict_str_destroy_elt P((t_hash_elt *he, t_dict *dict));
void dict_str_delete P((t_dict *dict));
char *dict_str_get P((t_dict *dict, char *key));
t_status dict_str_copy_override_walk P((t_hash_elt *he, t_dict *dst));
t_status dict_str_copy_override P((t_dict *src, t_dict *dst));
t_status dict_str_copy_silently_walk P((t_hash_elt *he, t_dict *dst));
t_status dict_str_copy_silently P((t_dict *src, t_dict *dst));
t_status dict_str_copy_override_suffix_walk P((t_hash_elt *he, t_dict_str_data *dsd));
t_status dict_str_copy_override_suffix P((t_dict *src, t_dict *dst, char *suffix));
t_status dict_str_get_sub_prefix_walk P((t_hash_elt *he, t_dict_str_data *dsd));
t_status dict_str_get_sub_prefix P((t_dict *src, t_dict *dst, char *prefix));
t_status dict_str_get_sub_prefix_to_vec_str_walk P((t_hash_elt *he, t_vec_str_data *vsd));
t_status dict_str_get_sub_prefix_to_vec_str P((t_dict *src, t_vec *dst, char *prefix));
t_status dict_str_get_sub_prefix_to_vec_str_sorted P((t_dict *src, t_vec *dst, char *prefix));
t_status dict_str_split P((t_dict *dict, char *str, int sep));
t_status dict_str_show_walk P((t_hash_elt *he));
void dict_str_show P((t_dict *dict));
#endif
