/*
** mg_dict.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:07:18 1999 vianney rancurel
** Last update Thu Oct 28 20:18:06 1999 
*/
#ifndef MG_DICT_H
#define MG_DICT_H	1

#include "mg.h"

typedef t_hash_code		(*t_dict_hash_code_proc) P((char *buf,
							    int len));

typedef struct			s_dict
{
  t_vec				*ht;
  t_dict_hash_code_proc		hash_code_proc;
} t_dict;

typedef t_status		(*t_dict_walk_proc) P((t_hash_elt *he,
						       VOID_PTR data));

typedef struct			s_dict_get_from_value_data
{
  VOID_PTR			value;
  t_hash_elt			*he;
} t_dict_get_from_value_data;

/* PROTO mg_dict.c */
/* mg_dict.c */
t_hash_code dict_hash_code_dragon P((char *buf, int len));
t_hash_code dict_hash_code_public P((char *buf, int len));
t_hash_code dict_hash_code_gst P((char *buf, int len));
t_dict *dict_new P((int base, int list_base, t_dict_hash_code_proc hash_code_proc, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
void dict_destroy_elt P((t_hash_elt *he, t_dict *dict));
void dict_destroy P((t_dict *dict));
void dict_delete P((t_dict *dict));
t_hash_elt *dict_get P((t_dict *dict, char *key));
t_status dict_add P((t_dict *dict, char *key, void *value));
t_status dict_override P((t_dict *dict, char *key, void *value));
t_status dict_rm P((t_dict *dict, char *key));
t_boolean dict_is_empty P((t_dict *dict));
int dict_count P((t_dict *dict));
t_status dict_walk P((t_dict *dict, t_dict_walk_proc proc, void *data));
t_status dict_to_vec_hash_elt P((t_dict *dict, t_vec *vec));
t_status dict_walk_sorted_cmp P((t_dict *dict, t_dict_walk_proc walk_proc, t_vec_cmp_proc cmp_proc, void *data));
int dict_walk_sorted_cmpproc P((void **p1, void **p2));
t_status dict_walk_sorted P((t_dict *dict, t_dict_walk_proc walk_proc, void *data));
t_status dict_max_len_walk P((t_hash_elt *he, int *max_len));
int dict_max_len P((t_dict *dict, t_status *status));
t_status dict_get_from_value_walk P((t_hash_elt *he, t_dict_get_from_value_data *dgfvd));
t_hash_elt *dict_get_from_value P((t_dict *dict, void *value, t_status *status));
t_status dict_change_key P((t_dict *dict, char *old_key, char *new_key));
t_status dict_show_walk P((t_hash_elt *he, void *unused));
void dict_show P((t_dict *dict));
void dict_show_sorted P((t_dict *dict));
#endif
