/*
** mg_arr.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:08:20 1999 vianney rancurel
** Last update Thu Oct 28 20:18:25 1999 
*/
#ifndef MG_ARR_H
#define MG_ARR_H	1

#include "mg.h"

#define ARR_BASE		32

typedef struct			s_arr
{
  size_t			eltsize;
  int				base;
  int				count;
  int				allocated;
  VOID_PTR			*elts;
  t_alloc_algorithm_proc	alloc_algorithm_proc;
  t_alloc_proc			alloc_proc;
  t_realloc_proc		realloc_proc;
  t_free_proc			free_proc;
  char				*comment;
} t_arr;

#define ARR_EMPTY(arr)		((arr)->count = 0)
#define ARR_COUNT(arr)		((arr)->count)
#define ARR_ALLOCATED(arr)	((arr)->allocated)
#define ARR_ELTSIZE(arr)	((arr)->eltsize)

/* PROTO mg_arr.c */
/* mg_arr.c */
t_status arr_alloc P((t_arr *arr, int n));
t_arr *arr_new P((size_t eltsize, int base, t_boolean now, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
void arr_destroy P((t_arr *arr));
void arr_delete P((t_arr *arr));
void *arr_next P((t_arr *arr, t_status *status));
void arr_rm P((t_arr *arr, int idx));
void arr_show P((t_arr *arr));
#endif
