/*
** mg_alloc.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:08:30 1999 vianney rancurel
** Last update Thu Oct 28 20:18:28 1999 
*/
#ifndef MG_ALLOC_H
#define MG_ALLOC_H	1

#include "mg.h"

typedef t_status	(*t_alloc_algorithm_proc) P((size_t old_size,
						     size_t request_size,
						     size_t *new_size));

typedef VOID_PTR	(*t_alloc_proc) P((size_t size,
					   char *comment1,
					   char *comment2,
					   t_status *status));

typedef VOID_PTR	(*t_realloc_proc) P((VOID_PTR oldptr,
					     size_t size,
					     char *comment1,
					     char *comment2,
					     t_status *status));

typedef VOID_FUNC	(*t_free_proc) P((VOID_PTR ptr,
					  char *comment1,
					  char *comment2));

/* PROTO mg_alloc.c */
/* mg_alloc.c */
void alloc_algorithm_status P((void));
t_status alloc_algorithm_exact P((size_t old_size, size_t request_size, size_t *new_size));
t_status alloc_algorithm_once P((size_t old_size, size_t request_size, size_t *new_size));
t_status alloc_algorithm_none P((size_t old_size, size_t request_size, size_t *new_size));
t_status alloc_algorithm_factor2 P((size_t old_size, size_t request_size, size_t *new_size));
void *alloc_malloc P((size_t size, char *comment1, char *comment2, t_status *status));
void *realloc_realloc P((void *old_ptr, size_t size, char *comment1, char *comment2, t_status *status));
void free_free P((void *ptr, char *comment1, char *comment2));
#endif
