/*
** XmgFileGet.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:14:49 1999 vianney rancurel
** Last update Thu Oct 28 20:22:30 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Viewport.h>
#include "FileNom.h"
#include "XmgMacro.h"
#include "XmgFileGet.h"

extern Widget			toplevel;
extern XtAppContext		app_context;

Widget				xmg_filenom_shell = NULL;
Widget				xmg_filenom = NULL;
char				*xmg_filename;
t_boolean			xmg_ok;
t_boolean			xmg_check_existence = FALSE;

VOID_FUNC			XmgFileGetSelectCallback(w,data,cbs)
Widget				w;
XtPointer			data;
FileNominatorStruct		*cbs;
{
  static char			path[MAXPATHLEN + 1];
  t_status			status;
  char				*fname;

  if (xmg_check_existence)
    if (cbs->filenameStatus & FileNominatorNonexistent)
      return ;
  XtPopdown(xmg_filenom_shell);
  path[0] = 0;
  if ((status = str_cat_str(path,
			    sizeof (path),
			    cbs->directoryPart)) != 0)
    {
      XmgErrPrint(toplevel,status,"str_cat_str");
      return ;
    }
  if ((status = str_cat_str(path,
			    sizeof (path),
			    cbs->filenamePart)) != 0)
    {
      XmgErrPrint(toplevel,status,"str_cat_str");
      return ;
    }
  xmg_filename = path;
  xmg_ok = TRUE;
} 

VOID_FUNC			XmgFileGetCancelCallback(w,data,cbs)
Widget				w;
XtPointer			data;
XtPointer			cbs;
{
  XtPopdown(xmg_filenom_shell);
  xmg_ok = TRUE;
}

/* gets a file name from a file selector shell.
   
   Warning: the widget is created during the first call of this
   function and is never recreated, just popdowned. */
char				*XmgFileGet(pattern,check_existence)
char				*pattern;		/* Regexp */
t_boolean			check_existence; /* The file must exist
						    to be accepted */
{
  if (!xmg_filenom_shell)
    {
      INTERFACE(toplevel,
		GETCHILDSHELL(xmg_filenom_shell)
		("xmgFileGetShell",transientShellWidgetClass,
		 XtNmappedWhenManaged,	False,
		 XtNtransientFor,	toplevel,
		 XtNallowShellResize,	True,
		 GETCHILD(xmg_filenom)
		 ("axeFileNominator",fileNominatorWidgetClass,
		  CALLBACK(XtNselectCallback,
			   XmgFileGetSelectCallback,
			   NULL),
		  CALLBACK(XtNcancelCallback,
			   XmgFileGetCancelCallback,
			   NULL),
		  END),
		 MANAGE,
		 END),
		ENDINTERFACE);
      XmgCenterWidget(xmg_filenom_shell);
    }
  XtVaSetValues(xmg_filenom,
		XtNfilter,		pattern,
		NULL);
  xmg_check_existence = check_existence;
  xmg_filename = NULL;
  xmg_ok = FALSE;
  XtPopup(xmg_filenom_shell,XtGrabExclusive);
  while (!xmg_ok)
    {
      XEvent		event;

      XtAppNextEvent(app_context,&event);
      XtDispatchEvent(&event);
    }
  return (xmg_filename);
}
