set debug 0
if {[lindex $argv  0] == "-d"} {
	set debug 1
	set argv [lrange $argv 1 end]
}
if {[lindex $argv  0] == "-dd"} {
	set debug 2
	set argv [lrange $argv 1 end]
}

proc test {name script result} {
global debug

	catch {exec -- ../../src/compiler << $script > /dev/null} msg
	set ok [string compare $msg $result]
	if {$debug && $ok == 0} {
		puts "==== OK for '$name'"
	}
	if {$ok != 0} {
		puts "==== ERROR in '$name'"
	}
	if {$ok != 0 || $debug == 2} {
		display ":::" $script 1
		display "<<<" $result
		display ">>>" $msg
	}
}

proc display {what string {tabulate 0}} {
	set i 1
	foreach l [split $string "\n"] {
		if {$tabulate} {
			regsub "^\t" $l {} l
			regsub -all "\t" $l {    } l
		}
		if {$what == ":::"} {
			puts "         [format %2d $i]: $l"
		} else {
			puts "         $what $l"
		}
		incr i
	}
	puts "         -----------------------------------------"
}
