# create a few packets
packet pkt 128
set debug 0

# helper routines
proc init {list} {
	set data ""
	foreach l $list {
		append data $l
	}
	pkt setfrom $data
}
proc enter {proto} {
global protocol debug

	set protocol $proto
	pkt decodefrom $proto

	puts "==== $proto"

	if {$debug} {
		puts "    ---------------------------------------------------------------------------"
		dump pkt $protocol 4
		puts "    ---------------------------------------------------------------------------"
	}
}
proc show {{force 0}} {
global protocol debug

	if {$debug || $force} {
		puts "        ---------------------------------------------------------------------------"
		dump pkt $protocol 8
		puts "        ---------------------------------------------------------------------------"
	}
}

# validate content of a field
proc check {name value limits get dir} {
global protocol debug


	if {[llength $limits]} {
		set lim [pkt $protocol limits $name]
		set ok [expr [lindex $limits 0]==[lindex $lim 0] && [lindex $limits 1]==[lindex $lim 1]]
	}
	if {$value == $get} {
		if  {[llength $limits] && !$ok} {
			puts "    [format %-45s $name$dir]LIMITS : got [lindex $lim 0]:[lindex $lim 1] expected [lindex $limits 0]:[lindex $limits 1]"
			show 1
		} elseif {$debug} {
			puts "    [format %-45s $name$dir]OK"
		}
	} else {
		puts "    [format %-45s $name$dir]ERROR : got '$get' expected '$value'"
		show 1
	}
}

#-------------------------------------------------------------------------------------------------
# validate getting
proc vg {name value {limits {}}} {
global protocol

	set get [pkt $protocol configure $name]
	check $name $value $limits $get " >>"
}
# validate getting (raw)
proc vrg {name value {limits {}}} {
global protocol

	set get [pkt $protocol getraw $name]
	check $name $value $limits $get " >"
}
# validate getting (verbose)
proc vvg {name value {limits {}}} {
global protocol

	set get [pkt $protocol getverbose $name]
	check $name $value $limits $get " >>>"
}

# validate getting with given protocol
proc vgp {proto name value {limits {}}} {

puts "set get \[pkt $proto configure $name\]  --  [pkt $proto configure]"
	set get [pkt $proto configure $name]
	check $name $value $limits $get ">"
}


#-------------------------------------------------------------------------------------------------
# validate setting of a field
proc vs {name value {limits {}}} {
global protocol debug

	pkt $protocol configure $name $value
	set get [pkt $protocol configure $name]
	check $name $value $limits $get " <$value< "
}
# validate setting of a field
proc vs2 {name valueSet valueGet {limits {}}} {
global protocol debug

	pkt $protocol configure $name $valueSet
	set get [pkt $protocol configure $name]
	check $name $valueGet $limits $get " <$valueSet< "
}
# validate setting of a field with error
proc vse {name value error} {
global protocol debug

	set data "$name <$value< "
	if {[catch {pkt $protocol configure $name $value} msg]} {
		if {[string compare $error $msg] != 0} {
			puts "    [format %-45s $data]ERROR : got '$msg' expected '$error'"
		} elseif {$debug} {
			puts "    [format %-45s $data]OK"
		}
	} else {
		puts "    [format %-45s $data]EXPECTING ERROR '$error' when setting to '$value'"
	}
}
