#-------------------------------------------------------------------------------------------------
#   RIP - Routing Information Protocol
#-------------------------------------------------------------------------------------------------

protocol router = {
	spec = "???"
    size = '%computedsize'

    field -command @ (0, 1) = {
		type = integer
		help = "command"
		default = 0
	}

    field -version @ (1, 1) = {
		type = integer
		help = "version"
		default = 1
	}

	field -domain @ (2, 2) = {
		type = integer
		help = "routing domain"
		default = 0
	}

	fieldvariablearray -data @ (4, '%toend') = {
		type = mapper(router_route)
		help = "routes"
	}
}

protocol router_route = {
	spec = "???"
    size = 20
	read-only

	field -family @ (0, 2) = {
		type = integer
		help = "family"
		default = 2
	}

	field -tag @ (2, 2) = {
		type = integer
		help = "route tag"
		default = 0
	}

	field -address @ (4, 4) = {
		type = address_ip
		help = "IP address"
		default = '127.0.0.1'
	}

	field -mask @ (8, 4) = {
		type = integer
		help = "network mask"
		default = 0
	}

	field -hopaddress @ (12, 4) = {
		type = address_ip
		help = "address to next hop"
		default = '0.0.0.0'
	}

	field -metric @ (16, 4) = {
		type = integer
		help = "metric"
		default = 0
	}
}
