#-------------------------------------------------------------------------------------------------
#   Ethernet MAC - Layer
#-------------------------------------------------------------------------------------------------

protocol ethernet = {
	spec = "RFC 1700 (Assigned Numbers)"
    size = 14
    nextlayer = '%string(-type)'

    field -src @ (6, 6) = {
        type = address_ethernet
        help = "source MAC"
		default = '%address_ethernet'
		read-only
    }

    field -dest @ (0, 6) = {
        type = address_ethernet
        help = "destination MAC"
		default = 'FF:FF:FF:FF:FF:FF'
    }

    field -type @ (12, 2) = {
        type = sparelist {
                   0x0000 "0x0000" "IEEE802.3 Length Field"
                   0x0101 "0x0101" "Experimental"
                   0x0200 "0x0200" "XEROX PUP (see 0A00)"
                   0x0201 "0x0201" "PUP Addr Trans (see 0A01)"
                   0x0600 "0x0600" "XEROX NS IDP"
                   0x0800 "ip" "Internet IP (IPv4)"
                   0x0801 "0x0801" "X.75 Internet"
                   0x0802 "0x0802" "NBS Internet"
                   0x0803 "0x0803" "ECMA Internet"
                   0x0804 "0x0804" "Chaosnet"
                   0x0805 "0x0805" "X.25 Level 3"
                   0x0806 "arp" "ARP"
                   0x0807 "0x0807" "XNS Compatability"
                   0x081c "0x081c" "Symbolics Private"
                   0x0888 "0x0888" "Xyplex"
                   0x0900 "0x0900" "Ungermann-Bass net debugr"
                   0x0a00 "0x0a00" "Xerox IEEE802.3 PUP"
                   0x0a01 "0x0a01" "PUP Addr Trans"
                   0x0bad "0x0bad" "Banyan Systems"
                   0x1000 "0x1000" "Berkeley Trailer nego"
                   0x1001 "0x1001" "Berkeley Trailer encap/IP"
                   0x1600 "0x1600" "Valid Systems"
                   0x1fd5 "0x1fd5" "Devices"
                   0x4242 "0x4242" "PCS Basic Block Protocol"
                   0x5208 "0x5208" "BBN Simnet"
                   0x6000 "0x6000" "DEC Unassigned (Exp.)"
                   0x6001 "0x6001" "DEC MOP Dump/Load"
                   0x6002 "0x6002" "DEC MOP Remote Console"
                   0x6003 "decnet" "DEC DECNET Phase IV Route"
                   0x6004 "0x6004" "DEC LAT"
                   0x6005 "0x6005" "DEC Diagnostic Protocol"
                   0x6006 "0x6006" "DEC Customer Protocol"
                   0x6007 "0x6007" "DEC LAVC, SCA"
                   0x6008 "0x6008" "DEC Unassigned"
                   0x600a "0x600a" "3Com Corporation"
                   0x7000 "0x7000" "Ungermann-Bass download"
                   0x7002 "0x7002" "Ungermann-Bass dia/loop"
                   0x7020 "0x7020" "LRT"
                   0x7030 "0x7030" "Proteon"
                   0x7034 "0x7034" "Cabletron"
                   0x8003 "0x8003" "Cronus VLN"
                   0x8004 "0x8004" "Cronus Direct"
                   0x8005 "0x8005" "HP Probe"
                   0x8006 "0x8006" "Nestar"
                   0x8008 "0x8008" "AT&T"
                   0x8010 "0x8010" "Excelan"
                   0x8013 "0x8013" "SGI diagnostics"
                   0x8014 "0x8014" "SGI network games"
                   0x8015 "0x8015" "SGI reserved"
                   0x8016 "0x8016" "SGI bounce server"
                   0x8019 "0x8019" "Apollo Computers"
                   0x802f "0x802f" "Tymshare"
                   0x8030 "0x8030" "Tigan, Inc."
                   0x8035 "rarp" "Reverse ARP"
                   0x8036 "0x8036" "Aeonic Systems"
                   0x8038 "0x8038" "DEC LANBridge"
                   0x8039 "0x8039" "DEC Unassigned"
                   0x803d "0x803d" "DEC Ethernet Encryption"
                   0x803e "0x803e" "DEC Unassigned"
                   0x803f "0x803f" "DEC LAN Traffic Monitor"
                   0x8040 "0x8040" "DEC Unassigned"
                   0x8044 "0x8044" "Planning Research Corp."
                   0x8046 "0x8046" "AT&T"
                   0x8047 "0x8047" "AT&T"
                   0x8049 "0x8049" "ExperData"
                   0x805b "0x805b" "Stanford V Kernel exp."
                   0x805c "0x805c" "Stanford V Kernel prod."
                   0x805d "0x805d" "Evans & Sutherland"
                   0x8060 "0x8060" "Little Machines"
                   0x8062 "0x8062" "Counterpoint Computers"
                   0x8065 "0x8065" "Univ. of Mass. @ Amherst"
                   0x8066 "0x8066" "Univ. of Mass. @ Amherst"
                   0x8067 "0x8067" "Veeco Integrated Auto."
                   0x8068 "0x8068" "General Dynamics"
                   0x8069 "0x8069" "AT&T"
                   0x806a "0x806a" "Autophon"
                   0x806c "0x806c" "ComDesign"
                   0x806d "0x806d" "Computgraphic Corp."
                   0x806e "0x806e" "Landmark Graphics Corp."
                   0x807a "0x807a" "Matra"
                   0x807b "0x807b" "Dansk Data Elektronik"
                   0x807c "0x807c" "Merit Internodal"
                   0x807d "0x807d" "Vitalink Communications"
                   0x8080 "0x8080" "Vitalink TransLAN III"
                   0x8081 "0x8081" "Counterpoint Computers"
                   0x809b "atalk" "Appletalk"
                   0x809c "0x809c" "Datability"
                   0x809f "0x809f" "Spider Systems Ltd."
                   0x80a3 "0x80a3" "Nixdorf Computers"
                   0x80a4 "0x80a4" "Siemens Gammasonics Inc."
                   0x80c0 "0x80c0" "DCA Data Exchange Cluster"
                   0x80c6 "0x80c6" "Pacer Software"
                   0x80c7 "0x80c7" "Applitek Corporation"
                   0x80c8 "0x80c8" "Intergraph Corporation"
                   0x80cd "0x80cd" "Harris Corporation"
                   0x80cf "0x80cf" "Taylor Instrument"
                   0x80d3 "0x80d3" "Rosemount Corporation"
                   0x80d5 "0x80d5" "IBM SNA Service on Ether"
                   0x80dd "0x80dd" "Varian Associates"
                   0x80de "0x80de" "Integrated Solutions TRFS"
                   0x80e0 "0x80e0" "Allen-Bradley"
                   0x80e4 "0x80e4" "Datability"
                   0x80f2 "0x80f2" "Retix"
                   0x80f3 "aarp" "AppleTalk AARP (Kinetics)"
                   0x80f4 "0x80f4" "Kinetics"
                   0x80f7 "0x80f7" "Apollo Computer"
                   0x80ff "0x80ff" "Wellfleet Communications"
                   0x8107 "0x8107" "Symbolics Private"
                   0x8130 "0x8130" "Hayes Microcomputers"
                   0x8131 "0x8131" "VG Laboratory Systems"
                   0x8137 "0x8137" "Novell, Inc."
                   0x8139 "0x8139" "KTI"
                   0x814c "0x814c" "SNMP"
                   0x86ef "0x86ef" "ATOMIC"
                   0x9000 "loopback" "Loopback"
                   0x9001 "0x9001" "3Com(Bridge) XNS Sys Mgmt"
                   0x9002 "0x9002" "3Com(Bridge) TCP-IP Sys"
                   0x9003 "0x9003" "3Com(Bridge) loop detect"
                   0xff00 "0xff00" "BBN VITAL-LanBridge cache"
               }
        help = "type of the encapuslated data in the frame"
		# set default to IP
        default = 0x0800
    }
}
