/* $Id: util.c,v 1.1 2001/01/05 01:10:52 keiji Exp $ */
/*
** util.c - utility functions for pakemon
** Author : Keiji Takeda
** 
** Pakemon is an abbreviation of "Packet Monster", a simple packet
** monitoring misuse detector.
**
** Copyright (C) 1999, 2000 Keiji Takeda <keiji@sfc.keio.ac.jp>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include "util.h"


/************************************************
  Function: malloc_check 
  Purpose: allocate memory with canary word and size
 ***********************************************/
void * malloc_check( int size, char *message )
{

  unsigned long *top, *end;

  top = (unsigned long *)malloc( size + sizeof(unsigned long)*3 );
  
  if( !top )
    {
      fprintf( stderr, "Memory Allocation Error: %s.\n", message );
      return (void *)NULL;
    }

  top[0] = size;

  top[1] = CANARY_WORD;

  end = ( unsigned long * )( (char *)&top[2] + size );

  end[0] = (unsigned long)CANARY_WORD;

  return ( void * )&top[2];

} /* malloc_check */

/************************************************
  Function: freec_check
  Purpose: free memory with checking canary word
 ***********************************************/
void free_check( void *memory, char *message )
{

  /* top address with size and canary to free */
  unsigned long *top, *end;

  /* memory is NULL */
  if( !memory )
    return;
 
  top = (unsigned long *)( (char *)memory - sizeof( unsigned long )*2 );

  if ( top[1] != CANARY_WORD )
    {
      fprintf( stderr, "Memory Underrun: %s\n", message );
      return;
    }

  end = (unsigned long *)( (char *)memory + top[0] );

  if( end[0] != CANARY_WORD )
    {
      fprintf( stderr, "Memory Overrun: %s\n", message );
      return;
    }

  free( top ); 

} /* free_check */






