/* $Id */
/*
** udp.c - udp part of pakemon
** Author : Keiji Takeda
**
** pakemon is an abbreviation of "Packet Monster", a simple packet
** monitoring misuse detector.
** Copyright (C) 1999, 2000 Keiji Takeda <keiji@sfc.keio.ac.jp>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pakemon.h"
#include "signature.h"

/*****************************************************
  Function: udp_callback
  Purpose: 
  Arguments:
       struct tuple4 * addr
       char * buf
       int len : length of UDP payload
       struct ip * iph
******************************************************/
void udp_callback(struct tuple4 * addr, char * dummy, int len,
		  struct ip * iph)
{
  struct ip_info ip_packet; /* pakemon.h */

  /*** initialize ip_packet with 0 ***/
  memset( &ip_packet, 0, sizeof(ip_packet));

 strcpy( ip_packet.src_IP, (char *)inet_ntoa( *(struct in_addr *)&( addr->saddr) ));

  strcpy( ip_packet.dest_IP, (char *)inet_ntoa( *(struct in_addr *)&( addr->daddr) ));

  ip_packet.src_number = addr->source;

  ip_packet.dest_number = addr->dest;

  ip_packet.ip_header = iph;

  ip_packet.trans_header = (u_char *)ip_packet.ip_header + 
    ((ip_packet.ip_header)->ip_hl ) * 4;

  /*** Extract Contents of the Packet ***/
  ip_packet.payload = (u_char *)ip_packet.trans_header + 
    sizeof( struct udphdr );

  ip_packet.payload_len = len;

  ip_packet.endof_payload = ip_packet.payload + len;

  read_payload( &ip_packet );

  if(pkmprm.verbose_mode)
    dump_packet_info( ip_packet, local_netaddr, local_netmask );

}/* udp_callback */






