/* $Id: signature.h,v 1.8 2000/10/23 11:21:06 keiji Exp $ */
/*
** signature.h v0.3.0 2000/02/22
** signature.h - header for the signature part of pakemon.
**
** Pakemon is an abbreviation of "Packet Monster", a simple packet
** monitoring misuse detector.
**
** Copyright (C) 1999, 2000 Keiji Takeda <keiji@sfc.keio.ac.jp>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __SIGNATURE_H
#define __SIGNATURE_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>     /* ULONG_MIN, ULONG_MAX */
#include <sys/types.h> /* netinet/in.h */
#include <netinet/in.h> /* IPPROTO_* */
#include <errno.h> /* IPPROTO_* */

#include "util.h"
#include "pakemon.h"
#include "match.h"

#define STD_BUF_SIZE 256
#define LARGE_BUF_SIZE 1024
#define DELIMITS " \t\n\r"
#define MAX_SIG_LENGTH 256
#define MAX_SIG_NUM 1000
#define CASE_INSENSE 0
#define CASE_SENSE 1
#define REGEXP 2

/* content node */
typedef struct content_node{
  struct content_node *next;
  void * s_node;
  u_int sig_id;
  u_char *pattern; 
  int pattern_len;
  u_char *delta1;
  u_char *delta2;
  struct re_pattern_buffer reg_pattern;
  char * name;
  u_char pattern_mode; /* CASE_INSENSE CASE_SENSE REGEXP */
} c_node;

/* service node */
typedef struct service_node{
  u_long src_number;
  u_long dest_number;
  c_node *c_tree;
  struct service_node *next;
} s_node;

/* length of signatures from a file */
struct signature_length
{
  int max;
  int min;
};

struct signature_length sig_len;

s_node *tcp_tree;

s_node *udp_tree;

s_node *icmp_tree;

/* prototype definition */
int get_next_str( char **reader, int max );
c_node *new_c_node(s_node *service,  u_int sig_id, u_char *pattern, u_int pattern_len, char * name, u_char pattern_mode );
s_node *new_s_node( u_long src_number,u_long dest_number );
s_node * get_s_node( char *protocol, u_long src_number, u_long dst_number );
c_node *detect_signature( struct ip_info *ip_packet,u_char * capital, s_node **s_node_ptr,  c_node **c_node_ptr );
int init_signature(char *sig_file);
int make_pattern( u_char *pattern, u_int patternsize, char *sig_reader, char *endof_sig, u_char pattern_mode );
int make_bin_pattern( u_char *sig_writer, char *bin_reader, char *endof_bin, u_char pattern_mode );
int dump_c_tree(s_node * s_tree );
void dump_s_tree(s_node * s_tree );
void free_s_tree( s_node * s_tree);
void free_c_tree( c_node * c_tree);
#endif /* __SIGNATURE_H */











