/* $Id: pakemon.h,v 1.10 2001/01/05 01:10:51 keiji Exp $ */
/*
** pakemon.h - Packet Monster main module header file
** Author: Keiji Takeda
**
** Pakemon is an abbreviation of "Packet Monster", a simple packet
** monitoring misuse detector.
**
** Copyright (C) 1999, 2000 Keiji Takeda <keiji@sfc.keio.ac.jp>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PAKEMON_H
#define __PAKEMON_H

#ifndef __FAVOR_BSD
#define __FAVOR_BSD
#endif /* __FAVOR_BSD */

#include <pcap.h>
#include <stdio.h>
#include <sys/types.h> /* umask */
#include <sys/stat.h> /* umask */
#include <signal.h> /* signal */
#include <ctype.h>
#include <syslog.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h> /* struct ip */
#include <arpa/inet.h>
#include <unistd.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <nids.h>
#include "scan.h"

#define DEFAULT_SIG_FILE "/usr/local/share/pakemon/signature.txt"
#define DEFAULT_BUFFER_SIZE 256
#define LOG_BUFFER_SIZE 8000
#define MAX_IP_SIZE 576
#define DEFAULT_ALERT_LOG "/var/log/pakemon_alert.log"
#define DEFAULT_DUMP_LOG "/var/log/pakemon_dump.log"
#define TERM_WIDTH 80
#define SCAN_PORT_NUM 100

#define LOG_NONE 0
#define LOG_BIN 1
#define LOG_TEXT 2

#define TRUE 1
#define FALSE 0

/* ip packet info package */
struct ip_info
{
  struct ip *ip_header;
  unsigned char *trans_header;
  u_char *payload;
  u_char *endof_payload;
  u_int payload_len;
  char src_IP[16], dest_IP[16];

  /* number = port number on TCP/UDP */
  /* src_number = type, dest_number = code on ICMP */

  u_long src_number, dest_number; 

};

/* connections to be reported (intrusion detected) */
struct report
{
  struct report *next_report;
  char report_id[DEFAULT_BUFFER_SIZE];
};

/* parameters */
struct pakemon_parameter
{
  /* verbose displays captured packet on screen */
  u_char verbose_mode;

  /* quiet mode doesn't alerts on screen */
  u_char std_alert;

  /* syslog for alert */
  u_char use_syslog;

  /* name of network interface device */
  char * interface_name;

  /* mode of dump log */
  u_char dump_log_mode;

  uid_t uid;

  char *sigfile, *alert_log_name, *dump_log_name;

} pkmprm;

/*************************/
/* global variables      */
/*************************/

struct report *head_report;

/* netmask for the local network used to find localnet */
struct in_addr local_netmask;

/* netmask for the local network used to find localnet */
struct in_addr local_netaddr;

/*************************/
/* prototype declaration */
/*************************/

void final( int signal);

void usage(void);

void read_ip(struct ip_info *ip_packet );

void dump_packet_info(struct ip_info ip_packet, 
		      struct in_addr local_netaddr,
		      struct in_addr local_netmask );
void read_payload(struct ip_info *ip_packet );
void ip_callback(struct ip * a_packet );
void make_filter(int optind, int args, char **argv );
void init_params( void );
int main(int args, char *argv[]);

/***********************************/
/* prototype declaration for tcp.c */
/***********************************/

void tcp_callback (struct tcp_stream *a_tcp, void ** dummy );

void read_tcp(struct ip_info *ip_packet);

/***********************************/
/* prototype declaration for udp.c */
/***********************************/
void udp_callback(struct tuple4 * addr, char * buf, int len, struct ip * iph);

void text_dump_payload(FILE *dump_log, struct ip_info * ip_packet, int width );

void bin_dump_payload(FILE *dump_log, struct ip_info * ip_packet);

/***********************************/
/* prototype declaration for icmp.c */
/***********************************/
void icmp_callback(struct ip_info *ip_packet );
void pakemon_syslog(int type, int errnum, struct ip * iph, void *data);

#endif /* __PAKEMON_H */









