/* $Id: interface.h,v 1.8 2000/10/06 07:26:11 keiji Exp $ */
/*
** interface.h - header file for interface.c of pakemon
** Author : Keiji Takeda
** 
** Pakemon is an abbreviation of "Packet Monster", a simple packet
** monitoring misuse detector.
**
** Copyright (C) 1999, 2000 Keiji Takeda <keiji@sfc.keio.ac.jp>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __INTERFACE_H
#define __INTERFACE_H

#define SNAPLEN 32000
#define PROMISC 1
#define TIMEOUT 500
#define STD_BUF_SIZE 256
#define EXTEND_BUF_SIZE 1024

#include <stdlib.h>
#include <pcap.h>
#include <netinet/in.h> /* struct in_addr */
#include <sys/socket.h> /* struct in_addr */
#include <net/if.h> /* struct ifreq */
#include <sys/ioctl.h> /*IOCGIFFLAGS, IFF_PROMISC, SIOCSIFFLAGS */
#include <string.h>

/* netmask for the local network used to find localnet */
extern struct in_addr local_netmask;

/* netmask for the local network used to find localnet */
extern struct in_addr local_netaddr;

/* prototype definition */
pcap_t * open_pcap(char **interface);

void get_local_info( char * interface, struct in_addr *local_netaddr, struct in_addr *local_netmask);
int reset_promisc(char *nic_name);

#endif /* __INTERFACE_H */








